/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.impl;

import java.util.Arrays;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.point.Point;

public class ArrayPoint
implements Point {
    private double[] point;

    public ArrayPoint(int dimensions) {
        this.point = new double[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            this.point[i] = 0.0;
        }
    }

    public ArrayPoint(Point point) {
        if (point == null) {
            throw new JMetalException("The point is null");
        }
        this.point = new double[point.getNumberOfDimensions()];
        for (int i = 0; i < point.getNumberOfDimensions(); ++i) {
            this.point[i] = point.getDimensionValue(i);
        }
    }

    public ArrayPoint(Solution<?> solution) {
        if (solution == null) {
            throw new JMetalException("The solution is null");
        }
        int dimensions = solution.getNumberOfObjectives();
        this.point = new double[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            this.point[i] = solution.getObjective(i);
        }
    }

    public ArrayPoint(double[] point) {
        if (point == null) {
            throw new JMetalException("The array of values is null");
        }
        this.point = new double[point.length];
        System.arraycopy(point, 0, this.point, 0, point.length);
    }

    @Override
    public int getNumberOfDimensions() {
        return this.point.length;
    }

    @Override
    public double[] getValues() {
        return this.point;
    }

    @Override
    public double getDimensionValue(int index) {
        if (index < 0 || index >= this.point.length) {
            throw new JMetalException("Index value invalid: " + index + ". The point length is: " + this.point.length);
        }
        return this.point[index];
    }

    @Override
    public void setDimensionValue(int index, double value) {
        if (index < 0 || index >= this.point.length) {
            throw new JMetalException("Index value invalid: " + index + ". The point length is: " + this.point.length);
        }
        this.point[index] = value;
    }

    public String toString() {
        String result = "";
        for (double anObjectives_ : this.point) {
            result = result + anObjectives_ + " ";
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayPoint that = (ArrayPoint)o;
        return Arrays.equals(this.point, that.point);
    }

    public int hashCode() {
        return Arrays.hashCode(this.point);
    }
}

