/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.distr.grid.common;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.jgap.util.FileKit;

public abstract class CommonConfiguration {
    private static final String CVS_REVISION = "$Revision: 1.2 $";
    private transient Logger LOGGER = Logger.getLogger(CommonConfiguration.class);
    private String m_workDir;
    private String m_libDir;
    private String m_server;

    public CommonConfiguration() {
    }

    public CommonConfiguration(String a_workDir, String a_libDir) {
        this();
        this.setWorkDir(a_workDir);
        this.setLibDir(a_libDir);
    }

    public void setWorkDir(String a_workDir) {
        try {
            this.m_workDir = FileKit.addSubDir(FileKit.getCurrentDir(), a_workDir, true);
            this.LOGGER.info((Object)("Using work directory " + this.m_workDir));
            if (!FileKit.directoryExists(this.m_workDir)) {
                this.LOGGER.info((Object)"  Directory does not exist yet. Wil create it.");
                FileKit.createDirectory(this.m_workDir);
            }
        }
        catch (IOException iex) {
            throw new RuntimeException("Work directory " + a_workDir + " is invalid!");
        }
    }

    public String getWorkDir() {
        return this.m_workDir;
    }

    public void setLibDir(String a_libDir) {
        try {
            this.m_libDir = FileKit.addSubDir(FileKit.getCurrentDir(), a_libDir, true);
            this.LOGGER.info((Object)("Using lib directory " + this.m_libDir));
            if (!FileKit.directoryExists(this.m_libDir)) {
                this.LOGGER.info((Object)"  Directory does not exist yet. Wil create it.");
                FileKit.createDirectory(this.m_libDir);
            }
        }
        catch (IOException iex) {
            throw new RuntimeException("Lib directory " + a_libDir + " is invalid!");
        }
    }

    public String getLibDir() {
        return this.m_libDir;
    }

    public void setServerAddress(String a_server) {
        this.m_server = a_server;
    }

    public String getServerAddress() {
        return this.m_server;
    }
}

