/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp;

import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.GPFitnessFunction;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;

public abstract class GPProgramBase
implements IGPProgram {
    private static final String CVS_REVISION = "$Revision: 1.14 $";
    private double m_fitnessValue = -1.0;
    private GPConfiguration m_conf;
    private Class[] m_types;
    private Class[][] m_argTypes;
    private CommandGene[][] m_nodeSets;
    private int[] m_minDepths;
    private int[] m_maxDepths;
    private int m_maxNodes;
    private Object m_applicationData;

    public GPProgramBase() throws Exception {
    }

    public GPProgramBase(GPConfiguration a_conf) throws InvalidConfigurationException {
        if (a_conf == null) {
            throw new InvalidConfigurationException("Configuration must not be null!");
        }
        this.m_conf = a_conf;
    }

    public GPProgramBase(IGPProgram a_prog) throws InvalidConfigurationException {
        this(a_prog.getGPConfiguration());
        this.m_types = a_prog.getTypes();
        this.m_argTypes = a_prog.getArgTypes();
        this.m_nodeSets = a_prog.getNodeSets();
        this.m_maxDepths = a_prog.getMaxDepths();
        this.m_minDepths = a_prog.getMinDepths();
        this.m_maxNodes = a_prog.getMaxNodes();
    }

    public GPConfiguration getGPConfiguration() {
        return this.m_conf;
    }

    public boolean equals(Object a_other) {
        try {
            return this.compareTo(a_other) == 0;
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public double calcFitnessValue() {
        GPFitnessFunction normalFitnessFunction = this.getGPConfiguration().getGPFitnessFunction();
        if (normalFitnessFunction != null) {
            this.m_fitnessValue = normalFitnessFunction.getFitnessValue(this);
        }
        if (Double.isInfinite(this.m_fitnessValue)) {
            return -1.0;
        }
        return this.m_fitnessValue;
    }

    public double getFitnessValue() {
        if (this.m_fitnessValue >= 0.0) {
            return this.m_fitnessValue;
        }
        return this.calcFitnessValue();
    }

    public double getFitnessValueDirectly() {
        return this.m_fitnessValue;
    }

    public void setFitnessValue(double a_fitness) {
        this.m_fitnessValue = a_fitness;
    }

    public void setTypes(Class[] a_types) {
        this.m_types = a_types;
    }

    public Class[] getTypes() {
        return this.m_types;
    }

    public Class getType(int a_index) {
        return this.m_types[a_index];
    }

    public void setArgTypes(Class[][] a_argTypes) {
        this.m_argTypes = a_argTypes;
    }

    public Class[][] getArgTypes() {
        return this.m_argTypes;
    }

    public Class[] getArgType(int a_index) {
        return this.m_argTypes[a_index];
    }

    public void setNodeSets(CommandGene[][] a_nodeSets) {
        this.m_nodeSets = a_nodeSets;
    }

    public CommandGene[][] getNodeSets() {
        return this.m_nodeSets;
    }

    public CommandGene[] getNodeSet(int a_index) {
        return this.m_nodeSets[a_index];
    }

    public void setMaxDepths(int[] a_maxDepths) {
        this.m_maxDepths = a_maxDepths;
    }

    public int[] getMaxDepths() {
        return this.m_maxDepths;
    }

    public void setMinDepths(int[] a_minDepths) {
        this.m_minDepths = a_minDepths;
    }

    public int[] getMinDepths() {
        return this.m_minDepths;
    }

    public void setMaxNodes(int a_maxNodes) {
        this.m_maxNodes = a_maxNodes;
    }

    public int getMaxNodes() {
        return this.m_maxNodes;
    }

    public void setApplicationData(Object a_data) {
        this.m_applicationData = a_data;
    }

    public Object getApplicationData() {
        return this.m_applicationData;
    }

    public abstract Object clone();
}

