/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.paes;

import org.uma.jmetal.algorithm.multiobjective.paes.PAES;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.AlgorithmBuilder;

public class PAESBuilder<S extends Solution<?>>
implements AlgorithmBuilder<PAES<S>> {
    private Problem<S> problem;
    private int archiveSize;
    private int maxEvaluations;
    private int biSections;
    private MutationOperator<S> mutationOperator;

    public PAESBuilder(Problem<S> problem) {
        this.problem = problem;
    }

    public PAESBuilder<S> setArchiveSize(int archiveSize) {
        this.archiveSize = archiveSize;
        return this;
    }

    public PAESBuilder<S> setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
        return this;
    }

    public PAESBuilder<S> setBiSections(int biSections) {
        this.biSections = biSections;
        return this;
    }

    public PAESBuilder<S> setMutationOperator(MutationOperator<S> mutation) {
        this.mutationOperator = mutation;
        return this;
    }

    @Override
    public PAES<S> build() {
        return new PAES<S>(this.problem, this.archiveSize, this.maxEvaluations, this.biSections, this.mutationOperator);
    }

    public Problem<S> getProblem() {
        return this.problem;
    }

    public int getArchiveSize() {
        return this.archiveSize;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getBiSections() {
        return this.biSections;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }
}

