/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;

public class GenerationalDistance<Evaluate extends List<? extends Solution<?>>>
extends SimpleDescribedEntity
implements QualityIndicator<Evaluate, Double> {
    private static final double POW = 2.0;
    private Front referenceParetoFront;

    public GenerationalDistance(String referenceParetoFrontFile) throws FileNotFoundException {
        super("GD", "Generational distance quality indicator");
        if (referenceParetoFrontFile == null) {
            throw new JMetalException("The pareto front object is null");
        }
        ArrayFront front = new ArrayFront(referenceParetoFrontFile);
        this.referenceParetoFront = front;
    }

    public GenerationalDistance(Front referenceParetoFront) {
        super("GD", "Generational distance quality indicator");
        if (referenceParetoFront == null) {
            throw new JMetalException("The pareto front is null");
        }
        this.referenceParetoFront = referenceParetoFront;
    }

    @Override
    public Double evaluate(Evaluate solutionList) {
        if (solutionList == null) {
            throw new JMetalException("The pareto front approximation is null");
        }
        return this.generationalDistance(new ArrayFront((List<? extends Solution<?>>)solutionList), this.referenceParetoFront);
    }

    public double generationalDistance(Front front, Front referenceFront) {
        double sum = 0.0;
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            sum += Math.pow(FrontUtils.distanceToClosestPoint(front.getPoint(i), referenceFront), 2.0);
        }
        sum = Math.pow(sum, 0.5);
        return sum / (double)front.getNumberOfPoints();
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

