/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Multimap<K, V> {
    private final Map<K, Collection<V>> storage = new HashMap<K, Collection<V>>();

    public Collection<V> get(K key) {
        return new LinkedList<V>(this.valueStoreFor(key));
    }

    public void put(K key, V value) {
        if (!this.storage.containsKey(key)) {
            this.storage.put(key, new LinkedList());
        }
        this.storage.get(key).add(value);
    }

    public void putAll(K key, Iterable<? extends V> values) {
        for (V element : values) {
            this.put(key, element);
        }
    }

    public void remove(K key, V value) {
        this.valueStoreFor(key).remove(value);
    }

    public void clear() {
        this.storage.clear();
    }

    public boolean containsKey(K key) {
        return !this.valueStoreFor(key).isEmpty();
    }

    public void replaceValues(K key, Iterable<? extends V> newValues) {
        this.removeAll(key);
        this.putAll(key, newValues);
    }

    private void removeAll(K key) {
        this.valueStoreFor(key).clear();
    }

    private Collection<V> valueStoreFor(K key) {
        return this.storage.containsKey(key) ? this.storage.get(key) : Collections.emptyList();
    }

    public String toString() {
        return this.storage.toString();
    }
}

