/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.EolLabeledBlock;
import org.eclipse.epsilon.eol.annotations.EolAnnotationsUtil;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolNoReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.evl.EvlConstraintContext;
import org.eclipse.epsilon.evl.EvlFix;
import org.eclipse.epsilon.evl.EvlFixInstance;
import org.eclipse.epsilon.evl.EvlGuard;
import org.eclipse.epsilon.evl.EvlUnsatisfiedConstraint;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;

public class EvlConstraint
extends AbstractModuleElement {
    protected String name;
    protected boolean isCritique = false;
    protected ArrayList<EvlFix> fixes = new ArrayList();
    protected EvlConstraintContext constraintContext;
    protected EvlGuard guard;
    protected EolLabeledBlock body;
    protected EolLabeledBlock message;

    public void build(AST ast) {
        this.ast = ast;
        if (ast.getType() == 81) {
            this.isCritique = true;
        }
        this.name = ast.getText();
        this.guard = new EvlGuard(AstUtil.getChild(ast, 79));
        this.body = new EolLabeledBlock(AstUtil.getChild(ast, 84), "check");
        this.message = new EolLabeledBlock(AstUtil.getChild(ast, 87), "message");
        List<AST> fixesAst = AstUtil.getChildren(ast, 83);
        Iterator it = fixesAst.iterator();
        while (it.hasNext()) {
            EvlFix fix = new EvlFix();
            fix.parse((AST)it.next());
            this.fixes.add(fix);
        }
    }

    public boolean isInfo() {
        return this.isCritique() && EolAnnotationsUtil.getAnnotation(this.ast, "info") != null;
    }

    public boolean isLazy(IEvlContext context) throws EolRuntimeException {
        return EolAnnotationsUtil.getBooleanAnnotationValue(this.ast, "lazy", context);
    }

    public boolean appliesTo(Object object, IEvlContext context) throws EolRuntimeException {
        if (!this.constraintContext.getAllOfSourceKind(context).contains(object)) {
            return false;
        }
        return this.guard.evaluate(object, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean check(Object self, IEvlContext context) throws EolRuntimeException {
        if (context.getConstraintTrace().isChecked(this, self)) {
            return context.getConstraintTrace().isSatisfied(this, self);
        }
        if (!this.appliesTo(self, context)) {
            return false;
        }
        context.getFrameStack().enterLocal(FrameType.UNPROTECTED, this.body.getAst(), new Variable[0]);
        context.getFrameStack().put(Variable.createReadOnlyVariable("self", self));
        Object result = context.getExecutorFactory().executeBlockOrExpressionAst(this.body.getAst(), context);
        if (!(result instanceof Return)) throw new EolNoReturnException("Boolean", this.body.getAst(), context);
        if ((result = Return.getValue(result)) instanceof Boolean) {
            boolean check = (Boolean)result;
            if (!check) {
                EvlUnsatisfiedConstraint unsatisfiedConstraint = new EvlUnsatisfiedConstraint();
                unsatisfiedConstraint.setInstance(self);
                unsatisfiedConstraint.setConstraint(this);
                ListIterator<EvlFix> li = this.fixes.listIterator();
                while (li.hasNext()) {
                    EvlFix fix = li.next();
                    if (!fix.appliesTo(self, context)) continue;
                    EvlFixInstance fixInstance = new EvlFixInstance(context);
                    fixInstance.setFix(fix);
                    fixInstance.setSelf(self);
                    unsatisfiedConstraint.getFixes().add(fixInstance);
                }
                String messageResult = null;
                if (this.message.getAst() != null) {
                    Object messageAstResult = context.getExecutorFactory().executeBlockOrExpressionAst(this.message.getAst(), context);
                    if (!(messageAstResult instanceof Return)) throw new EolNoReturnException("Any", this.message.getAst(), context);
                    messageResult = context.getPrettyPrinterManager().toString(Return.getValue(messageAstResult));
                } else {
                    messageResult = "Invariant " + this.getName() + " failed for " + context.getPrettyPrinterManager().toString(self);
                }
                unsatisfiedConstraint.setMessage(messageResult);
                context.getConstraintTrace().addChecked(this, self, false);
                context.getUnsatisfiedConstraints().add(unsatisfiedConstraint);
                context.getFrameStack().leaveLocal(this.body.getAst(), false);
                return false;
            }
            context.getConstraintTrace().addChecked(this, self, true);
            context.getFrameStack().leaveLocal(this.body.getAst());
            return true;
        }
        context.getFrameStack().leaveLocal(this.body.getAst());
        throw new EolIllegalReturnException("Boolean", result, this.body.getAst(), context);
    }

    @Override
    public AST getAst() {
        return this.ast;
    }

    @Override
    public List<?> getChildren() {
        return Collections.emptyList();
    }

    public EvlConstraintContext getConstraintContext() {
        return this.constraintContext;
    }

    public void setConstraintContext(EvlConstraintContext constraintContext) {
        this.constraintContext = constraintContext;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCritique() {
        return this.isCritique;
    }

    public void setCritique(boolean isCritique) {
        this.isCritique = isCritique;
    }
}

