/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.profiling.Profiler;
import org.eclipse.epsilon.workflow.tasks.EpsilonTask;

public class StoreModelTask
extends EpsilonTask {
    protected String model;
    protected File target;

    @Override
    public void executeImpl() throws BuildException {
        if (this.profile) {
            Profiler.INSTANCE.start("Store model : " + this.model);
        }
        try {
            try {
                IModel eolModel = this.getProjectRepository().getModelByName(this.model);
                if (this.target != null) {
                    eolModel.store("file:/" + this.target.getAbsolutePath());
                } else {
                    eolModel.store();
                }
            }
            catch (EolModelNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            if (this.profile) {
                Profiler.INSTANCE.stop("Store model : " + this.model);
            }
        }
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File target) {
        this.target = target;
    }
}

