/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eml.MergeRule;
import org.eclipse.epsilon.eml.MergeRules;
import org.eclipse.epsilon.eml.execute.EmlExecutorFactory;
import org.eclipse.epsilon.eml.execute.context.EmlContext;
import org.eclipse.epsilon.eml.parse.EmlLexer;
import org.eclipse.epsilon.eml.parse.EmlParser;
import org.eclipse.epsilon.eol.EolImport;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.etl.EtlModule;

public class EmlModule
extends EtlModule {
    protected EmlContext context = new EmlContext();
    protected MergeRules declaredMergeRules = null;
    protected MergeRules mergeRules = null;

    public EmlModule() {
        this.reset();
    }

    @Override
    public Lexer createLexer(InputStream inputStream) {
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new EmlLexer(input);
    }

    @Override
    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EmlParser(tokenStream);
    }

    @Override
    public String getMainRule() {
        return "emlModule";
    }

    @Override
    public HashMap<String, Class<?>> getImportConfiguration() {
        HashMap<String, Class<?>> importConfiguration = super.getImportConfiguration();
        importConfiguration.put("eml", EmlModule.class);
        return importConfiguration;
    }

    @Override
    public void buildModel() throws Exception {
        super.buildModel();
        for (AST mergeRuleAst : AstUtil.getChildren(this.ast, 81)) {
            this.declaredMergeRules.add(new MergeRule(mergeRuleAst));
        }
        this.getParseProblems().addAll(this.declaredMergeRules.calculateSuperRules(this.getMergeRules()));
    }

    @Override
    public Object execute() throws EolRuntimeException {
        this.prepareContext(this.context);
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("matchTrace", this.context.getMatchTrace()));
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("mergeTrace", this.context.getMergeTrace()));
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("transTrace", this.context.getTransformationTrace()));
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("context", this.context));
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("thisModule", this));
        EmlExecutorFactory emlExecutorFactory = new EmlExecutorFactory();
        emlExecutorFactory.setExecutionController(this.context.getExecutorFactory().getExecutionController());
        this.context.setExecutorFactory(emlExecutorFactory);
        this.execute(this.getPre(), this.context);
        this.context.getMergingStrategy().mergeModels(this.context);
        this.execute(this.getPost(), this.context);
        return null;
    }

    @Override
    public EmlContext getContext() {
        return this.context;
    }

    @Override
    public void reset() {
        super.reset();
        this.declaredMergeRules = new MergeRules();
        this.mergeRules = null;
    }

    public MergeRules getDeclaredMergeRules() {
        return this.declaredMergeRules;
    }

    public MergeRules getMergeRules() {
        if (this.mergeRules == null) {
            this.mergeRules = new MergeRules();
            for (EolImport import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof EmlModule)) continue;
                EmlModule module = (EmlModule)import_.getModule();
                this.mergeRules.addAll(module.getMergeRules());
            }
            this.mergeRules.addAll(this.declaredMergeRules);
        }
        return this.mergeRules;
    }

    @Override
    public List<ModuleElement> getChildren() {
        ArrayList<ModuleElement> children = new ArrayList<ModuleElement>();
        children.addAll(this.getImports());
        children.addAll(this.getDeclaredPre());
        children.addAll(this.declaredMergeRules);
        children.addAll(this.declaredTransformRules);
        children.addAll(this.getDeclaredPost());
        children.addAll(this.getDeclaredOperations());
        return children;
    }

    @Override
    protected int getPostBlockTokenType() {
        return 77;
    }

    @Override
    protected int getPreBlockTokenType() {
        return 76;
    }
}

