/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import java.util.Arrays;

public final class VMath {
    public static final double DELTA = 1.0E-5;
    public static final String ERR_VEC_DIMENSIONS = "Vector dimensions do not agree.";
    public static final String ERR_MATRIX_DIMENSIONS = "Matrix dimensions do not agree.";
    public static final String ERR_MATRIX_INNERDIM = "Matrix inner dimensions do not agree.";
    private static final String ERR_DIMENSIONS = "Dimensionalities do not agree.";

    private VMath() {
    }

    public static final double[] randomNormalizedVector(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.random();
        }
        double d = VMath.euclideanLength(dArray);
        if (d != 0.0) {
            int n2 = 0;
            while (n2 < dArray.length) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] / d;
            }
            return dArray;
        }
        return VMath.randomNormalizedVector(n);
    }

    public static final double[] unitVector(int n, int n2) {
        double[] dArray = new double[n];
        dArray[n2] = 1.0;
        return dArray;
    }

    public static final double[] copy(double[] dArray) {
        return Arrays.copyOf(dArray, dArray.length);
    }

    public static final double[][] transpose(double[] dArray) {
        double[][] dArray2 = new double[dArray.length][1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][0] = dArray[i];
        }
        return dArray2;
    }

    public static final double[] plus(double[] dArray, double[] dArray2) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
        }
        return dArray3;
    }

    public static final double[] plusTimes(double[] dArray, double[] dArray2, double d) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i] + dArray2[i] * d;
        }
        return dArray3;
    }

    public static final double[] timesPlus(double[] dArray, double d, double[] dArray2) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i] * d + dArray2[i];
        }
        return dArray3;
    }

    public static final double[] timesPlusTimes(double[] dArray, double d, double[] dArray2, double d2) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i] * d + dArray2[i] * d2;
        }
        return dArray3;
    }

    public static final double[] plusEquals(double[] dArray, double[] dArray2) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] + dArray2[i];
        }
        return dArray;
    }

    public static final double[] plusTimesEquals(double[] dArray, double[] dArray2, double d) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] + d * dArray2[i];
        }
        return dArray;
    }

    public static final double[] timesPlusEquals(double[] dArray, double d, double[] dArray2) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] * d + dArray2[i];
        }
        return dArray;
    }

    public static final double[] timesPlusTimesEquals(double[] dArray, double d, double[] dArray2, double d2) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] * d + dArray2[i] * d2;
        }
        return dArray;
    }

    public static final double[] plus(double[] dArray, double d) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i] + d;
        }
        return dArray2;
    }

    public static final double[] plusEquals(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] + d;
        }
        return dArray;
    }

    public static final double[] minus(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        return dArray3;
    }

    public static final double[] minusTimes(double[] dArray, double[] dArray2, double d) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] - dArray2[i] * d;
        }
        return dArray3;
    }

    public static final double[] timesMinus(double[] dArray, double d, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] * d - dArray2[i];
        }
        return dArray3;
    }

    public static final double[] timesMinusTimes(double[] dArray, double d, double[] dArray2, double d2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] * d - dArray2[i] * d2;
        }
        return dArray3;
    }

    public static final double[] minusEquals(double[] dArray, double[] dArray2) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] - dArray2[i];
        }
        return dArray;
    }

    public static final double[] minusTimesEquals(double[] dArray, double[] dArray2, double d) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] - dArray2[i] * d;
        }
        return dArray;
    }

    public static final double[] timesMinusEquals(double[] dArray, double d, double[] dArray2) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] * d - dArray2[i];
        }
        return dArray;
    }

    public static final double[] timesMinusTimesEquals(double[] dArray, double d, double[] dArray2, double d2) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] * d - dArray2[i] * d2;
        }
        return dArray;
    }

    public static final double[] minus(double[] dArray, double d) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] - d;
        }
        return dArray2;
    }

    public static final double[] minusEquals(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] - d;
        }
        return dArray;
    }

    public static final double[] times(double[] dArray, double d) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] * d;
        }
        return dArray2;
    }

    public static final double[] timesEquals(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
        return dArray;
    }

    public static final double[][] times(double[] dArray, double[][] dArray2) {
        assert (dArray2.length == 1) : "Matrix inner dimensions do not agree.";
        int n = dArray2[0].length;
        double[][] dArray3 = new double[dArray.length][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray3[j][i] = dArray[j] * dArray2[0][i];
            }
        }
        return dArray3;
    }

    public static final double[][] transposeTimes(double[] dArray, double[][] dArray2) {
        assert (dArray2.length == dArray.length) : "Matrix inner dimensions do not agree.";
        int n = dArray2[0].length;
        double[][] dArray3 = new double[1][n];
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                d += dArray[j] * dArray2[j][i];
            }
            dArray3[0][i] = d;
        }
        return dArray3;
    }

    public static final double transposeTimes(double[] dArray, double[] dArray2) {
        assert (dArray2.length == dArray.length) : "Matrix inner dimensions do not agree.";
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static final double[][] timesTranspose(double[] dArray, double[][] dArray2) {
        assert (dArray2[0].length == 1) : "Matrix inner dimensions do not agree.";
        double[][] dArray3 = new double[dArray.length][dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray3[j][i] = dArray[j] * dArray2[i][0];
            }
        }
        return dArray3;
    }

    public static final double[][] timesTranspose(double[] dArray, double[] dArray2) {
        double[][] dArray3 = new double[dArray.length][dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray3[j][i] = dArray[j] * dArray2[i];
            }
        }
        return dArray3;
    }

    public static final double scalarProduct(double[] dArray, double[] dArray2) {
        assert (dArray.length == dArray2.length) : "Vector dimensions do not agree.";
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static final double squareSum(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            d += d2 * d2;
        }
        return d;
    }

    public static final double euclideanLength(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public static final double[] normalize(double[] dArray) {
        double d = VMath.euclideanLength(dArray);
        double[] dArray2 = new double[dArray.length];
        if (d != 0.0) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = dArray[i] / d;
            }
        }
        return dArray2;
    }

    public static final double[] normalizeEquals(double[] dArray) {
        double d = VMath.euclideanLength(dArray);
        if (d != 0.0) {
            int n = 0;
            while (n < dArray.length) {
                int n2 = n++;
                dArray[n2] = dArray[n2] / d;
            }
        }
        return dArray;
    }

    public static final double[] project(double[] dArray, double[][] dArray2) {
        assert (dArray.length == dArray2.length) : "Dimensionalities do not agree.";
        int n = dArray2[0].length;
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < n; ++i) {
            double[] dArray4 = VMath.getCol(dArray2, i);
            VMath.plusTimesEquals(dArray3, dArray4, VMath.scalarProduct(dArray, dArray4));
        }
        return dArray3;
    }

    public static final int hashCode(double[] dArray) {
        return Arrays.hashCode(dArray);
    }

    public static final boolean equals(double[] dArray, double[] dArray2) {
        return Arrays.equals(dArray, dArray2);
    }

    public static final void clear(double[] dArray) {
        Arrays.fill(dArray, 0.0);
    }

    public static final double[] rotate90Equals(double[] dArray) {
        assert (dArray.length == 2) : "rotate90Equals is only valid for 2d vectors.";
        double d = dArray[0];
        dArray[0] = dArray[1];
        dArray[1] = -d;
        return dArray;
    }

    public static final double[][] unitMatrix(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return dArray;
    }

    public static final double[][] zeroMatrix(int n) {
        double[][] dArray = new double[n][n];
        return dArray;
    }

    public static final double[][] random(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = Math.random();
            }
        }
        return dArray;
    }

    public static final double[][] identity(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < Math.min(n, n2); ++i) {
            dArray[i][i] = 1.0;
        }
        return dArray;
    }

    public static final double[][] diagonal(double[] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][i] = dArray[i];
        }
        return dArray2;
    }

    public static final double[][] copy(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[dArray.length][n];
        for (int i = 0; i < dArray.length; ++i) {
            System.arraycopy(dArray[i], 0, dArray2[i], 0, n);
        }
        return dArray2;
    }

    public static final double[] rowPackedCopy(double[][] dArray) {
        int n = dArray[0].length;
        double[] dArray2 = new double[dArray.length * n];
        for (int i = 0; i < dArray.length; ++i) {
            System.arraycopy(dArray[i], 0, dArray2, i * n, n);
        }
        return dArray2;
    }

    public static final double[] columnPackedCopy(double[][] dArray) {
        int n = dArray[0].length;
        double[] dArray2 = new double[dArray.length * n];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i + j * dArray.length] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static final double[][] getMatrix(double[][] dArray, int n, int n2, int n3, int n4) {
        double[][] dArray2 = new double[n2 - n + 1][n4 - n3 + 1];
        for (int i = n; i <= n2; ++i) {
            System.arraycopy(dArray[i], n3, dArray2[i - n], 0, n4 - n3 + 1);
        }
        return dArray2;
    }

    public static final double[][] getMatrix(double[][] dArray, int[] nArray, int[] nArray2) {
        double[][] dArray2 = new double[nArray.length][nArray2.length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                dArray2[i][j] = dArray[nArray[i]][nArray2[j]];
            }
        }
        return dArray2;
    }

    public static final double[][] getMatrix(double[][] dArray, int[] nArray, int n, int n2) {
        double[][] dArray2 = new double[nArray.length][n2 - n + 1];
        for (int i = 0; i < nArray.length; ++i) {
            System.arraycopy(dArray[nArray[i]], n, dArray2[i], 0, n2 - n + 1);
        }
        return dArray2;
    }

    public static final double[][] getMatrix(double[][] dArray, int n, int n2, int[] nArray) {
        double[][] dArray2 = new double[n2 - n + 1][nArray.length];
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                dArray2[i - n][j] = dArray[i][nArray[j]];
            }
        }
        return dArray2;
    }

    public static final void setMatrix(double[][] dArray, int n, int n2, int n3, int n4, double[][] dArray2) {
        for (int i = n; i <= n2; ++i) {
            System.arraycopy(dArray2[i - n], 0, dArray[i], n3, n4 - n3 + 1);
        }
    }

    public static final void setMatrix(double[][] dArray, int[] nArray, int[] nArray2, double[][] dArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                dArray[nArray[i]][nArray2[j]] = dArray2[i][j];
            }
        }
    }

    public static final void setMatrix(double[][] dArray, int[] nArray, int n, int n2, double[][] dArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            System.arraycopy(dArray2[i], 0, dArray[nArray[i]], n, n2 - n + 1);
        }
    }

    public static final void setMatrix(double[][] dArray, int n, int n2, int[] nArray, double[][] dArray2) {
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                dArray[i][nArray[j]] = dArray2[i - n][j];
            }
        }
    }

    public static final double[] getRow(double[][] dArray, int n) {
        return (double[])dArray[n].clone();
    }

    public static final void setRow(double[][] dArray, int n, double[] dArray2) {
        int n2 = VMath.getColumnDimensionality(dArray);
        assert (dArray2.length == n2) : "Dimensionalities do not agree.";
        System.arraycopy(dArray2, 0, dArray[n], 0, n2);
    }

    public static final double[] getCol(double[][] dArray, int n) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i][n];
        }
        return dArray2;
    }

    public static final void setCol(double[][] dArray, int n, double[] dArray2) {
        assert (dArray2.length == dArray.length) : "Dimensionalities do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i][n] = dArray2[i];
        }
    }

    public static final double[][] transpose(double[][] dArray) {
        int n = VMath.getColumnDimensionality(dArray);
        double[][] dArray2 = new double[n][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static final double[][] plus(double[][] dArray, double[][] dArray2) {
        return VMath.plusEquals(VMath.copy(dArray), dArray2);
    }

    public static final double[][] plusTimes(double[][] dArray, double[][] dArray2, double d) {
        return VMath.plusTimesEquals(VMath.copy(dArray), dArray2, d);
    }

    public static final double[][] plusEquals(double[][] dArray, double[][] dArray2) {
        int n = VMath.getColumnDimensionality(dArray);
        assert (VMath.getRowDimensionality(dArray) == VMath.getRowDimensionality(dArray2) && n == VMath.getColumnDimensionality(dArray2)) : "Matrix dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                double[] dArray3 = dArray[i];
                int n2 = j;
                dArray3[n2] = dArray3[n2] + dArray2[i][j];
            }
        }
        return dArray;
    }

    public static final double[][] plusTimesEquals(double[][] dArray, double[][] dArray2, double d) {
        int n = VMath.getColumnDimensionality(dArray);
        assert (VMath.getRowDimensionality(dArray) == VMath.getRowDimensionality(dArray2) && n == VMath.getColumnDimensionality(dArray2)) : "Matrix dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                double[] dArray3 = dArray[i];
                int n2 = j;
                dArray3[n2] = dArray3[n2] + d * dArray2[i][j];
            }
        }
        return dArray;
    }

    public static final double[][] minus(double[][] dArray, double[][] dArray2) {
        return VMath.minusEquals(VMath.copy(dArray), dArray2);
    }

    public static final double[][] minusTimes(double[][] dArray, double[][] dArray2, double d) {
        return VMath.minusTimesEquals(VMath.copy(dArray), dArray2, d);
    }

    public static final double[][] minusEquals(double[][] dArray, double[][] dArray2) {
        int n = VMath.getColumnDimensionality(dArray);
        assert (VMath.getRowDimensionality(dArray) == VMath.getRowDimensionality(dArray2) && n == VMath.getColumnDimensionality(dArray2)) : "Matrix dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                double[] dArray3 = dArray[i];
                int n2 = j;
                dArray3[n2] = dArray3[n2] - dArray2[i][j];
            }
        }
        return dArray;
    }

    public static final double[][] minusTimesEquals(double[][] dArray, double[][] dArray2, double d) {
        assert (VMath.getRowDimensionality(dArray) == VMath.getRowDimensionality(dArray2) && VMath.getColumnDimensionality(dArray) == VMath.getColumnDimensionality(dArray2)) : "Matrix dimensions do not agree.";
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < dArray3.length; ++j) {
                int n = j;
                dArray3[n] = dArray3[n] - d * dArray4[j];
            }
        }
        return dArray;
    }

    public static final double[][] times(double[][] dArray, double d) {
        return VMath.timesEquals(VMath.copy(dArray), d);
    }

    public static final double[][] timesEquals(double[][] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray2 = dArray[i];
            int n = 0;
            while (n < dArray2.length) {
                int n2 = n++;
                dArray2[n2] = dArray2[n2] * d;
            }
        }
        return dArray;
    }

    public static final double[][] times(double[][] dArray, double[][] dArray2) {
        int n = VMath.getColumnDimensionality(dArray);
        int n2 = VMath.getColumnDimensionality(dArray2);
        assert (dArray2.length == n) : "Matrix inner dimensions do not agree.";
        double[][] dArray3 = new double[dArray.length][n2];
        double[] dArray4 = new double[n];
        for (int i = 0; i < n2; ++i) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                dArray4[n3] = dArray2[n3][i];
            }
            for (n3 = 0; n3 < dArray.length; ++n3) {
                double[] dArray5 = dArray[n3];
                double d = 0.0;
                for (int j = 0; j < n; ++j) {
                    d += dArray5[j] * dArray4[j];
                }
                dArray3[n3][i] = d;
            }
        }
        return dArray3;
    }

    public static final double[] times(double[][] dArray, double[] dArray2) {
        assert (dArray2.length == VMath.getColumnDimensionality(dArray)) : "Matrix inner dimensions do not agree.";
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray4 = dArray[i];
            double d = 0.0;
            for (int j = 0; j < dArray4.length; ++j) {
                d += dArray4[j] * dArray2[j];
            }
            dArray3[i] = d;
        }
        return dArray3;
    }

    public static final double[] transposeTimes(double[][] dArray, double[] dArray2) {
        int n = VMath.getColumnDimensionality(dArray);
        assert (dArray2.length == dArray.length) : "Matrix inner dimensions do not agree.";
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                d += dArray[j][i] * dArray2[j];
            }
            dArray3[i] = d;
        }
        return dArray3;
    }

    public static final double[][] transposeTimes(double[][] dArray, double[][] dArray2) {
        int n = VMath.getColumnDimensionality(dArray);
        int n2 = VMath.getColumnDimensionality(dArray2);
        assert (dArray2.length == dArray.length) : "Matrix inner dimensions do not agree.";
        double[][] dArray3 = new double[n][n2];
        double[] dArray4 = new double[dArray.length];
        for (int i = 0; i < n2; ++i) {
            int n3;
            for (n3 = 0; n3 < dArray.length; ++n3) {
                dArray4[n3] = dArray2[n3][i];
            }
            for (n3 = 0; n3 < n; ++n3) {
                double d = 0.0;
                for (int j = 0; j < dArray.length; ++j) {
                    d += dArray[j][n3] * dArray4[j];
                }
                dArray3[n3][i] = d;
            }
        }
        return dArray3;
    }

    public static double transposeTimesTimes(double[] dArray, double[][] dArray2, double[] dArray3) {
        assert (dArray2.length == dArray.length) : "Matrix inner dimensions do not agree.";
        double d = 0.0;
        for (int i = 0; i < dArray2[0].length; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                d2 += dArray[j] * dArray2[j][i];
            }
            d += d2 * dArray3[i];
        }
        return d;
    }

    public static final double[][] timesTranspose(double[][] dArray, double[][] dArray2) {
        assert (VMath.getColumnDimensionality(dArray2) == VMath.getColumnDimensionality(dArray)) : "Matrix inner dimensions do not agree.";
        double[][] dArray3 = new double[dArray.length][dArray2.length];
        for (int i = 0; i < dArray3.length; ++i) {
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < dArray.length; ++j) {
                double[] dArray5 = dArray[j];
                double d = 0.0;
                for (int k = 0; k < dArray4.length; ++k) {
                    d += dArray5[k] * dArray4[k];
                }
                dArray3[j][i] = d;
            }
        }
        return dArray3;
    }

    public static final double[][] transposeTimesTranspose(double[][] dArray, double[][] dArray2) {
        assert (dArray.length == VMath.getColumnDimensionality(dArray2)) : "Matrix inner dimensions do not agree.";
        double[][] dArray3 = new double[VMath.getColumnDimensionality(dArray)][dArray2.length];
        double[] dArray4 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray4[j] = dArray[j][i];
            }
            double[] dArray5 = dArray3[i];
            for (int j = 0; j < dArray2.length; ++j) {
                double[] dArray6 = dArray2[j];
                double d = 0.0;
                for (int k = 0; k < dArray.length; ++k) {
                    d += dArray6[k] * dArray4[k];
                }
                dArray5[j] = d;
            }
        }
        return dArray3;
    }

    public static double mahalanobisDistance(double[][] dArray, double[] dArray2, double[] dArray3) {
        assert (dArray.length == dArray2.length && dArray2.length == dArray3.length) : "Matrix inner dimensions do not agree.";
        double d = 0.0;
        for (int i = 0; i < dArray[0].length; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < dArray2.length; ++j) {
                d2 += (dArray2[j] - dArray3[j]) * dArray[j][i];
            }
            d += d2 * (dArray2[i] - dArray3[i]);
        }
        return d;
    }

    public static final double[] getDiagonal(double[][] dArray) {
        int n = Math.min(VMath.getColumnDimensionality(dArray), dArray.length);
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i][i];
        }
        return dArray2;
    }

    public static final void normalizeColumns(double[][] dArray) {
        int n = VMath.getColumnDimensionality(dArray);
        for (int i = 0; i < n; ++i) {
            int n2;
            double d = 0.0;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                d += dArray[n2][i] * dArray[n2][i];
            }
            if ((d = Math.sqrt(d)) == 0.0) continue;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                double[] dArray2 = dArray[n2];
                int n3 = i;
                dArray2[n3] = dArray2[n3] / d;
            }
        }
    }

    public static final double[][] appendColumns(double[][] dArray, double[][] dArray2) {
        int n = VMath.getColumnDimensionality(dArray);
        int n2 = VMath.getColumnDimensionality(dArray2);
        assert (dArray.length == dArray2.length) : "m.getRowDimension() != column.getRowDimension()";
        int n3 = n + n2;
        double[][] dArray3 = new double[dArray.length][n3];
        for (int i = 0; i < n3; ++i) {
            if (i < n) {
                VMath.setCol(dArray3, i, VMath.getCol(dArray, i));
                continue;
            }
            VMath.setCol(dArray3, i, VMath.getCol(dArray2, i - n));
        }
        return dArray3;
    }

    public static final double[][] orthonormalize(double[][] dArray) {
        int n = VMath.getColumnDimensionality(dArray);
        double[][] dArray2 = VMath.copy(dArray);
        for (int i = 1; i < n; ++i) {
            double[] dArray3 = VMath.getCol(dArray, i);
            double[] dArray4 = new double[dArray.length];
            for (int j = 0; j < i; ++j) {
                double[] dArray5 = VMath.getCol(dArray2, j);
                double d = VMath.scalarProduct(dArray3, dArray5) / VMath.scalarProduct(dArray5, dArray5);
                VMath.plusEquals(dArray4, VMath.times(dArray5, d));
            }
            double[] dArray6 = VMath.minus(dArray3, dArray4);
            VMath.setCol(dArray2, i, dArray6);
        }
        VMath.normalizeColumns(dArray2);
        return dArray2;
    }

    public static final int hashCode(double[][] dArray) {
        return Arrays.hashCode((Object[])dArray);
    }

    public static final boolean equals(double[][] dArray, double[][] dArray2) {
        return Arrays.equals((Object[])dArray, (Object[])dArray2);
    }

    public static final boolean almostEquals(double[][] dArray, double[][] dArray2, double d) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray2 == null) {
            return false;
        }
        if (dArray.getClass() != dArray2.getClass()) {
            return false;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        int n = VMath.getColumnDimensionality(dArray);
        if (n != VMath.getColumnDimensionality(dArray2)) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!(Math.abs(dArray[i][j] - dArray2[i][j]) > d)) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean almostEquals(double[][] dArray, double[][] dArray2) {
        return VMath.almostEquals(dArray, dArray2, 1.0E-5);
    }

    public static final int getRowDimensionality(double[][] dArray) {
        return dArray.length;
    }

    public static final int getColumnDimensionality(double[][] dArray) {
        return dArray[0].length;
    }

    public static void cross3D(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[1] * dArray3[2] - dArray2[2] * dArray3[1];
        dArray[1] = dArray2[2] * dArray3[0] - dArray2[0] * dArray3[2];
        dArray[2] = dArray2[0] * dArray3[1] - dArray2[1] * dArray3[0];
    }
}

