/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.batikutil.ThumbnailRegistryEntry;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGCloneVisible;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.util.Base64EncoderStream;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CloneInlineImages
extends SVGCloneVisible {
    @Override
    public Node cloneNode(Document document, Node node) {
        Element element;
        Node node2 = null;
        if (node instanceof Element && (element = (Element)node).getTagName().equals("image")) {
            String string = element.getAttributeNS("http://www.w3.org/1999/xlink", "href");
            ParsedURL parsedURL = new ParsedURL(string);
            if (ThumbnailRegistryEntry.isCompatibleURLStatic(parsedURL)) {
                node2 = this.inlineThumbnail(document, parsedURL, node);
            } else if ("file".equals(parsedURL.getProtocol())) {
                node2 = this.inlineExternal(document, parsedURL, node);
            }
        }
        if (node2 != null) {
            return node2;
        }
        return super.cloneNode(document, node);
    }

    protected Node inlineThumbnail(Document document, ParsedURL parsedURL, Node node) {
        Object object;
        Filter filter = ThumbnailRegistryEntry.handleURL(parsedURL);
        if (filter == null) {
            LoggingUtil.warning("Image not found in registry: " + parsedURL.toString());
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write("data:image/png;base64,".getBytes());
            object = new Base64EncoderStream(byteArrayOutputStream);
            ImageIO.write(filter.createDefaultRendering(), "png", (OutputStream)object);
            ((Base64EncoderStream)object).close();
        }
        catch (IOException iOException) {
            LoggingUtil.exception("Exception serializing image to png", iOException);
            return null;
        }
        object = (Element)super.cloneNode(document, node);
        object.setAttributeNS("http://www.w3.org/1999/xlink", "href", byteArrayOutputStream.toString().replaceAll("\\s*[\\r\\n]+\\s*", ""));
        return object;
    }

    protected Node inlineExternal(Document document, ParsedURL parsedURL, Node node) {
        Object object;
        File file = new File(parsedURL.getPath());
        if (!file.exists()) {
            LoggingUtil.warning("Referencing non-existant file: " + parsedURL.toString());
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            byteArrayOutputStream.write("data:image/png;base64,".getBytes());
            object = new Base64EncoderStream(byteArrayOutputStream);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                ((Base64EncoderStream)object).write(byArray, 0, n);
            }
            fileInputStream.close();
            ((Base64EncoderStream)object).close();
        }
        catch (IOException iOException) {
            LoggingUtil.exception("Exception serializing image to png", iOException);
            return null;
        }
        object = (Element)super.cloneNode(document, node);
        object.setAttributeNS("http://www.w3.org/1999/xlink", "href", byteArrayOutputStream.toString().replaceAll("\\s*[\\r\\n]+\\s*", ""));
        return object;
    }
}

