/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.subspace;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialPrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.AbstractDimensionsSelectingDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public class SubspaceLPNormDistanceFunction
extends AbstractDimensionsSelectingDistanceFunction<NumberVector>
implements SpatialPrimitiveDistanceFunction<NumberVector>,
Norm<NumberVector>,
NumberVectorDistanceFunction<NumberVector> {
    private double p;

    public SubspaceLPNormDistanceFunction(double d, long[] lArray) {
        super(lArray);
        this.p = d;
    }

    public double getP() {
        return this.p;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        if (numberVector.getDimensionality() != numberVector2.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of FeatureVectors\n  first argument: " + numberVector + "\n  " + "second argument: " + numberVector2);
        }
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            double d2 = Math.abs(numberVector.doubleValue(n) - numberVector2.doubleValue(n));
            d += Math.pow(d2, this.p);
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return Math.pow(d, 1.0 / this.p);
    }

    protected double minDistObject(SpatialComparable spatialComparable, NumberVector numberVector) {
        if (spatialComparable.getDimensionality() != numberVector.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of objects\n  first argument: " + spatialComparable.toString() + "\n  " + "second argument: " + numberVector.toString());
        }
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            block7: {
                double d2;
                block6: {
                    double d3;
                    block5: {
                        double d4;
                        d3 = numberVector.doubleValue(n);
                        if (!(d3 < (d4 = spatialComparable.getMin(n)))) break block5;
                        d2 = d4 - d3;
                        break block6;
                    }
                    double d5 = spatialComparable.getMax(n);
                    if (!(d3 > d5)) break block7;
                    d2 = d3 - d5;
                }
                d += Math.pow(d2, this.p);
            }
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return Math.pow(d, 1.0 / this.p);
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        if (spatialComparable.getDimensionality() != spatialComparable2.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of objects\n  first argument: " + spatialComparable.toString() + "\n  " + "second argument: " + spatialComparable2.toString());
        }
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            block7: {
                double d2;
                block6: {
                    double d3;
                    block5: {
                        double d4;
                        double d5 = spatialComparable.getMax(n);
                        if (!(d5 < (d4 = spatialComparable2.getMin(n)))) break block5;
                        d2 = d4 - d5;
                        break block6;
                    }
                    double d6 = spatialComparable.getMin(n);
                    if (!(d6 > (d3 = spatialComparable2.getMax(n)))) break block7;
                    d2 = d6 - d3;
                }
                d += Math.pow(d2, this.p);
            }
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return Math.pow(d, 1.0 / this.p);
    }

    @Override
    public double norm(NumberVector numberVector) {
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            double d2 = Math.abs(numberVector.doubleValue(n));
            d += Math.pow(d2, this.p);
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return Math.pow(d, 1.0 / this.p);
    }

    @Override
    public <T extends NumberVector> SpatialPrimitiveDistanceQuery<T> instantiate(Relation<T> relation) {
        return new SpatialPrimitiveDistanceQuery<NumberVector>((Relation<NumberVector>)relation, this);
    }

    @Override
    public VectorFieldTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    public static class Parameterizer
    extends AbstractDimensionsSelectingDistanceFunction.Parameterizer {
        private double p;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter = new DoubleParameter(LPNormDistanceFunction.Parameterizer.P_ID);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.p = (Double)doubleParameter.getValue();
            }
            super.makeOptions(parameterization);
        }

        @Override
        protected SubspaceLPNormDistanceFunction makeInstance() {
            if (this.p == 2.0) {
                return new SubspaceEuclideanDistanceFunction(this.dimensions);
            }
            if (this.p == 1.0) {
                return new SubspaceManhattanDistanceFunction(this.dimensions);
            }
            return new SubspaceLPNormDistanceFunction(this.p, this.dimensions);
        }
    }
}

