/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LUDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.linearalgebra.QRDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SingularValueDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class Matrix {
    public static final double DELTA = 0.001;
    public static final double SINGULARITY_CHEAT = 1.0E-9;
    public static final String ERR_NOTRECTANGULAR = "All rows must have the same length.";
    public static final String ERR_REINDEX = "Submatrix indices incorrect.";
    public static final String ERR_MATRIX_DIMENSIONS = "Matrix must consist of the same no of rows!";
    private static final String ERR_MATRIX_INNERDIM = "Matrix inner dimensions must agree.";
    protected final double[][] elements;
    final int columndimension;

    public Matrix(int n, int n2) {
        this.columndimension = n2;
        this.elements = new double[n][n2];
    }

    public Matrix(int n, int n2, double d) {
        this.columndimension = n2;
        this.elements = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.elements[i][j] = d;
            }
        }
    }

    public Matrix(double[][] dArray) {
        this.columndimension = dArray[0].length;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i].length == this.columndimension) continue;
            throw new IllegalArgumentException(ERR_NOTRECTANGULAR);
        }
        this.elements = dArray;
    }

    public Matrix(double[] dArray, int n) {
        int n2 = this.columndimension = n != 0 ? dArray.length / n : 0;
        if (n * this.columndimension != dArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.elements = new double[n][this.columndimension];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.columndimension; ++j) {
                this.elements[i][j] = dArray[i + j * n];
            }
        }
    }

    public Matrix(Matrix matrix) {
        this(matrix.getArrayCopy());
    }

    public static final Matrix constructWithCopy(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        Matrix matrix = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            if (dArray[i].length != n2) {
                throw new IllegalArgumentException(ERR_NOTRECTANGULAR);
            }
            System.arraycopy(dArray[i], 0, matrix.elements[i], 0, n2);
        }
        return matrix;
    }

    public static final Matrix unitMatrix(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return new Matrix(dArray);
    }

    public static final Matrix zeroMatrix(int n) {
        double[][] dArray = new double[n][n];
        return new Matrix(dArray);
    }

    public static final Matrix random(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix.elements[i][j] = Math.random();
            }
        }
        return matrix;
    }

    public static final Matrix identity(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        for (int i = 0; i < Math.min(n, n2); ++i) {
            matrix.elements[i][i] = 1.0;
        }
        return matrix;
    }

    public static final Matrix diagonal(double[] dArray) {
        Matrix matrix = new Matrix(dArray.length, dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            matrix.elements[i][i] = dArray[i];
        }
        return matrix;
    }

    public static final Matrix diagonal(Vector vector) {
        Matrix matrix = new Matrix(vector.elements.length, vector.elements.length);
        for (int i = 0; i < vector.elements.length; ++i) {
            matrix.elements[i][i] = vector.elements[i];
        }
        return matrix;
    }

    public final Matrix copy() {
        Matrix matrix = new Matrix(this.elements.length, this.columndimension);
        for (int i = 0; i < this.elements.length; ++i) {
            System.arraycopy(this.elements[i], 0, matrix.elements[i], 0, this.columndimension);
        }
        return matrix;
    }

    public Matrix clone() {
        return this.copy();
    }

    public final double[][] getArrayRef() {
        return this.elements;
    }

    public final double[][] getArrayCopy() {
        double[][] dArrayArray = new double[this.elements.length][];
        for (int i = 0; i < this.elements.length; ++i) {
            dArrayArray[i] = (double[])this.elements[i].clone();
        }
        return dArrayArray;
    }

    public final int getRowDimensionality() {
        return this.elements.length;
    }

    public final int getColumnDimensionality() {
        return this.columndimension;
    }

    public final double get(int n, int n2) {
        return this.elements[n][n2];
    }

    public final Matrix set(int n, int n2, double d) {
        this.elements[n][n2] = d;
        return this;
    }

    public final Matrix increment(int n, int n2, double d) {
        double[] dArray = this.elements[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
        return this;
    }

    public final double[] getRowPackedCopy() {
        double[] dArray = new double[this.elements.length * this.columndimension];
        for (int i = 0; i < this.elements.length; ++i) {
            System.arraycopy(this.elements[i], 0, dArray, i * this.columndimension, this.columndimension);
        }
        return dArray;
    }

    public final double[] getColumnPackedCopy() {
        double[] dArray = new double[this.elements.length * this.columndimension];
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.columndimension; ++j) {
                dArray[i + j * this.elements.length] = this.elements[i][j];
            }
        }
        return dArray;
    }

    public final Matrix getMatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(n2 - n + 1, n4 - n3 + 1);
        try {
            for (int i = n; i <= n2; ++i) {
                System.arraycopy(this.elements[i], n3, matrix.elements[i - n], 0, n4 - n3 + 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(ERR_REINDEX);
        }
        return matrix;
    }

    public final Matrix getMatrix(int[] nArray, int[] nArray2) {
        Matrix matrix = new Matrix(nArray.length, nArray2.length);
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    matrix.elements[i][j] = this.elements[nArray[i]][nArray2[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(ERR_REINDEX);
        }
        return matrix;
    }

    public final Matrix getMatrix(int[] nArray, int n, int n2) {
        Matrix matrix = new Matrix(nArray.length, n2 - n + 1);
        try {
            for (int i = 0; i < nArray.length; ++i) {
                System.arraycopy(this.elements[nArray[i]], n, matrix.elements[i], 0, n2 - n + 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(ERR_REINDEX);
        }
        return matrix;
    }

    public final Matrix getMatrix(int n, int n2, int[] nArray) {
        Matrix matrix = new Matrix(n2 - n + 1, nArray.length);
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    matrix.elements[i - n][j] = this.elements[i][nArray[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(ERR_REINDEX);
        }
        return matrix;
    }

    public final void setMatrix(int n, int n2, int n3, int n4, Matrix matrix) {
        try {
            for (int i = n; i <= n2; ++i) {
                System.arraycopy(matrix.elements[i - n], 0, this.elements[i], n3, n4 - n3 + 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(ERR_REINDEX);
        }
    }

    public final void setMatrix(int[] nArray, int[] nArray2, Matrix matrix) {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    this.elements[nArray[i]][nArray2[j]] = matrix.elements[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(ERR_REINDEX);
        }
    }

    public final void setMatrix(int[] nArray, int n, int n2, Matrix matrix) {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                System.arraycopy(matrix.elements[i], 0, this.elements[nArray[i]], n, n2 - n + 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(ERR_REINDEX);
        }
    }

    public final void setMatrix(int n, int n2, int[] nArray, Matrix matrix) {
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    this.elements[i][nArray[j]] = matrix.elements[i - n][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(ERR_REINDEX);
        }
    }

    public final Vector getRow(int n) {
        double[] dArray = (double[])this.elements[n].clone();
        return new Vector(dArray);
    }

    public final void setRow(int n, Vector vector) {
        if (vector.elements.length != this.columndimension) {
            throw new IllegalArgumentException(ERR_MATRIX_DIMENSIONS);
        }
        System.arraycopy(vector.elements, 0, this.elements[n], 0, this.columndimension);
    }

    public final Vector getCol(int n) {
        Vector vector = new Vector(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            vector.elements[i] = this.elements[i][n];
        }
        return vector;
    }

    public final void setCol(int n, Vector vector) {
        if (vector.elements.length != this.elements.length) {
            throw new IllegalArgumentException(ERR_MATRIX_DIMENSIONS);
        }
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i][n] = vector.elements[i];
        }
    }

    public final Matrix transpose() {
        Matrix matrix = new Matrix(this.columndimension, this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.columndimension; ++j) {
                matrix.elements[j][i] = this.elements[i][j];
            }
        }
        return matrix;
    }

    public final Matrix plus(Matrix matrix) {
        return this.copy().plusEquals(matrix);
    }

    public final Matrix plus(double d) {
        return this.copy().plusEquals(d);
    }

    public final Matrix plusDiagonal(double d) {
        return this.copy().plusDiagonalEquals(d);
    }

    public final Matrix plusTimes(Matrix matrix, double d) {
        return this.copy().plusTimesEquals(matrix, d);
    }

    public final Matrix plusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.columndimension; ++j) {
                double[] dArray = this.elements[i];
                int n = j;
                dArray[n] = dArray[n] + matrix.elements[i][j];
            }
        }
        return this;
    }

    public final Matrix plusEquals(double d) {
        for (int i = 0; i < this.elements.length; ++i) {
            int n = 0;
            while (n < this.columndimension) {
                double[] dArray = this.elements[i];
                int n2 = n++;
                dArray[n2] = dArray[n2] + d;
            }
        }
        return this;
    }

    public final Matrix plusDiagonalEquals(double d) {
        int n = 0;
        while (n < this.elements.length && n < this.columndimension) {
            double[] dArray = this.elements[n];
            int n2 = n++;
            dArray[n2] = dArray[n2] + d;
        }
        return this;
    }

    public final Matrix plusTimesEquals(Matrix matrix, double d) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.columndimension; ++j) {
                double[] dArray = this.elements[i];
                int n = j;
                dArray[n] = dArray[n] + d * matrix.elements[i][j];
            }
        }
        return this;
    }

    public final Matrix minus(Matrix matrix) {
        return this.copy().minusEquals(matrix);
    }

    public final Matrix minusTimes(Matrix matrix, double d) {
        return this.copy().minusTimesEquals(matrix, d);
    }

    public final Matrix minusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.columndimension; ++j) {
                double[] dArray = this.elements[i];
                int n = j;
                dArray[n] = dArray[n] - matrix.elements[i][j];
            }
        }
        return this;
    }

    public final Matrix minusTimesEquals(Matrix matrix, double d) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.columndimension; ++j) {
                double[] dArray = this.elements[i];
                int n = j;
                dArray[n] = dArray[n] - d * matrix.elements[i][j];
            }
        }
        return this;
    }

    public final Matrix times(double d) {
        return this.copy().timesEquals(d);
    }

    public final Matrix timesEquals(double d) {
        for (int i = 0; i < this.elements.length; ++i) {
            int n = 0;
            while (n < this.columndimension) {
                double[] dArray = this.elements[i];
                int n2 = n++;
                dArray[n2] = dArray[n2] * d;
            }
        }
        return this;
    }

    public final Matrix times(Matrix matrix) {
        if (matrix.elements.length != this.columndimension) {
            throw new IllegalArgumentException(ERR_MATRIX_INNERDIM);
        }
        Matrix matrix2 = new Matrix(this.elements.length, matrix.columndimension);
        double[] dArray = new double[this.columndimension];
        for (int i = 0; i < matrix2.columndimension; ++i) {
            int n;
            for (n = 0; n < this.columndimension; ++n) {
                dArray[n] = matrix.elements[n][i];
            }
            for (n = 0; n < this.elements.length; ++n) {
                double[] dArray2 = this.elements[n];
                double d = 0.0;
                for (int j = 0; j < this.columndimension; ++j) {
                    d += dArray2[j] * dArray[j];
                }
                matrix2.elements[n][i] = d;
            }
        }
        return matrix2;
    }

    public final Vector times(Vector vector) {
        if (vector.elements.length != this.columndimension) {
            throw new IllegalArgumentException(ERR_MATRIX_INNERDIM);
        }
        Vector vector2 = new Vector(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            double[] dArray = this.elements[i];
            double d = 0.0;
            for (int j = 0; j < this.columndimension; ++j) {
                d += dArray[j] * vector.elements[j];
            }
            vector2.elements[i] = d;
        }
        return vector2;
    }

    public final Vector transposeTimes(Vector vector) {
        if (vector.elements.length != this.elements.length) {
            throw new IllegalArgumentException(ERR_MATRIX_INNERDIM);
        }
        Vector vector2 = new Vector(this.columndimension);
        for (int i = 0; i < this.columndimension; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.elements.length; ++j) {
                d += this.elements[j][i] * vector.elements[j];
            }
            vector2.elements[i] = d;
        }
        return vector2;
    }

    public final Matrix transposeTimes(Matrix matrix) {
        if (matrix.elements.length != this.elements.length) {
            throw new IllegalArgumentException(ERR_MATRIX_INNERDIM);
        }
        Matrix matrix2 = new Matrix(this.columndimension, matrix.columndimension);
        double[] dArray = new double[this.elements.length];
        for (int i = 0; i < matrix2.columndimension; ++i) {
            int n;
            for (n = 0; n < this.elements.length; ++n) {
                dArray[n] = matrix.elements[n][i];
            }
            for (n = 0; n < this.columndimension; ++n) {
                double d = 0.0;
                for (int j = 0; j < this.elements.length; ++j) {
                    d += this.elements[j][n] * dArray[j];
                }
                matrix2.elements[n][i] = d;
            }
        }
        return matrix2;
    }

    public final Matrix timesTranspose(Matrix matrix) {
        if (matrix.columndimension != this.columndimension) {
            throw new IllegalArgumentException(ERR_MATRIX_INNERDIM);
        }
        Matrix matrix2 = new Matrix(this.elements.length, matrix.elements.length);
        for (int i = 0; i < matrix2.elements.length; ++i) {
            double[] dArray = matrix.elements[i];
            for (int j = 0; j < this.elements.length; ++j) {
                double[] dArray2 = this.elements[j];
                double d = 0.0;
                for (int k = 0; k < this.columndimension; ++k) {
                    d += dArray2[k] * dArray[k];
                }
                matrix2.elements[j][i] = d;
            }
        }
        return matrix2;
    }

    public final Matrix transposeTimesTranspose(Matrix matrix) {
        if (this.elements.length != matrix.columndimension) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree: " + this.getRowDimensionality() + "," + this.getColumnDimensionality() + " * " + matrix.getRowDimensionality() + "," + matrix.getColumnDimensionality());
        }
        Matrix matrix2 = new Matrix(this.columndimension, matrix.elements.length);
        double[] dArray = new double[this.elements.length];
        for (int i = 0; i < matrix2.elements.length; ++i) {
            for (int j = 0; j < this.elements.length; ++j) {
                dArray[j] = this.elements[j][i];
            }
            double[] dArray2 = matrix2.elements[i];
            for (int j = 0; j < matrix.elements.length; ++j) {
                double[] dArray3 = matrix.elements[j];
                double d = 0.0;
                for (int k = 0; k < matrix.columndimension; ++k) {
                    d += dArray3[k] * dArray[k];
                }
                dArray2[j] = d;
            }
        }
        return matrix2;
    }

    public final Matrix solve(Matrix matrix) {
        return this.elements.length == this.columndimension ? new LUDecomposition(this).solve(matrix) : new QRDecomposition(this).solve(matrix);
    }

    public final Matrix inverse() {
        return this.solve(Matrix.identity(this.elements.length, this.elements.length));
    }

    public final Matrix robustInverse() {
        LUDecomposition lUDecomposition = new LUDecomposition(this);
        if (!lUDecomposition.isNonsingular()) {
            lUDecomposition = new LUDecomposition(this.plusDiagonal(1.0E-9).getArrayRef(), this.elements.length, this.columndimension);
        }
        return lUDecomposition.solve(Matrix.identity(this.elements.length, this.elements.length));
    }

    public final double det() {
        return new LUDecomposition(this).det();
    }

    public final int rank() {
        return new SingularValueDecomposition(this).rank();
    }

    public final double cond() {
        return new SingularValueDecomposition(this).cond();
    }

    public final double trace() {
        double d = 0.0;
        for (int i = 0; i < Math.min(this.elements.length, this.columndimension); ++i) {
            d += this.elements[i][i];
        }
        return d;
    }

    public final double norm1() {
        double d = 0.0;
        for (int i = 0; i < this.columndimension; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.elements.length; ++j) {
                d2 += Math.abs(this.elements[j][i]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public final double norm2() {
        return new SingularValueDecomposition(this).norm2();
    }

    public final double normInf() {
        double d = 0.0;
        for (int i = 0; i < this.elements.length; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.columndimension; ++j) {
                d2 += Math.abs(this.elements[i][j]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public final double normF() {
        double d = 0.0;
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.columndimension; ++j) {
                d = MathUtil.fastHypot(d, this.elements[i][j]);
            }
        }
        return d;
    }

    public final void normalizeColumns() {
        for (int i = 0; i < this.columndimension; ++i) {
            int n;
            double d = 0.0;
            for (n = 0; n < this.elements.length; ++n) {
                d += this.elements[n][i] * this.elements[n][i];
            }
            if ((d = Math.sqrt(d)) == 0.0) continue;
            for (n = 0; n < this.elements.length; ++n) {
                double[] dArray = this.elements[n];
                int n2 = i;
                dArray[n2] = dArray[n2] / d;
            }
        }
    }

    public final boolean linearlyIndependent(Matrix matrix) {
        int n;
        if (matrix.columndimension != 1) {
            throw new IllegalArgumentException("a.getColumnDimension() != 1");
        }
        if (this.elements.length != matrix.elements.length) {
            throw new IllegalArgumentException(ERR_MATRIX_DIMENSIONS);
        }
        if (this.columndimension + matrix.columndimension > this.elements.length) {
            return false;
        }
        StringBuilder stringBuilder = LoggingConfiguration.DEBUG ? new StringBuilder() : null;
        double[][] dArray = new double[this.columndimension + 1][this.elements.length - 1];
        double[] dArray2 = new double[this.columndimension + 1];
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray[n].length; ++i) {
                dArray[n][i] = n < this.columndimension ? this.elements[i][n] : matrix.elements[i][0];
            }
        }
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = n < this.columndimension ? this.elements[this.elements.length - 1][n] : matrix.elements[n][0];
        }
        LinearEquationSystem linearEquationSystem = new LinearEquationSystem(dArray, dArray2);
        linearEquationSystem.solveByTotalPivotSearch();
        double[][] dArray3 = linearEquationSystem.getCoefficents();
        double[] dArray4 = linearEquationSystem.getRHS();
        if (stringBuilder != null) {
            stringBuilder.append("\na' ").append(FormatUtil.format(this.getArrayRef()));
            stringBuilder.append("\nb' ").append(FormatUtil.format(matrix.getColumnPackedCopy()));
            stringBuilder.append("\na ").append(FormatUtil.format(dArray));
            stringBuilder.append("\nb ").append(FormatUtil.format(dArray2));
            stringBuilder.append("\nleq ").append(linearEquationSystem.equationsToString(4));
        }
        for (int i = 0; i < dArray3.length; ++i) {
            double d;
            boolean bl = true;
            for (int j = 0; j < dArray3[i].length; ++j) {
                double d2 = dArray3[i][j];
                if (!(Math.abs(d2) > 0.001)) continue;
                bl = false;
                break;
            }
            if (!bl || !(Math.abs(d = dArray4[i]) < 0.001)) continue;
            if (stringBuilder != null) {
                stringBuilder.append("\nvalue ").append(d).append('[').append(i).append(']');
                stringBuilder.append("\nlinearly independent ").append(false);
                Logger.getLogger(this.getClass().getName()).fine(stringBuilder.toString());
            }
            return false;
        }
        if (stringBuilder != null) {
            stringBuilder.append("\nlinearly independent ").append(true);
            Logger.getLogger(this.getClass().getName()).fine(stringBuilder.toString());
        }
        return true;
    }

    public final boolean isSymmetric() {
        if (this.elements.length != this.columndimension) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = i + 1; j < this.columndimension; ++j) {
                if (this.elements[i][j] == this.elements[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public final Matrix completeBasis() {
        Matrix matrix = this.copy();
        Matrix matrix2 = null;
        for (int i = 0; i < this.elements.length; ++i) {
            Matrix matrix3 = new Matrix(this.elements.length, 1);
            matrix3.elements[0][i] = 1.0;
            boolean bl = matrix.linearlyIndependent(matrix3);
            if (!bl) continue;
            matrix2 = matrix2 == null ? matrix3.copy() : matrix2.appendColumns(matrix3);
            matrix = matrix.appendColumns(matrix3);
        }
        return matrix2;
    }

    public final Matrix completeToOrthonormalBasis() {
        Matrix matrix = this.copy();
        Matrix matrix2 = null;
        for (int i = 0; i < this.elements.length; ++i) {
            Matrix matrix3 = new Matrix(this.elements.length, 1);
            matrix3.elements[i][0] = 1.0;
            boolean bl = matrix.linearlyIndependent(matrix3);
            if (!bl) continue;
            matrix2 = matrix2 == null ? matrix3.copy() : matrix2.appendColumns(matrix3);
            matrix = matrix.appendColumns(matrix3);
        }
        matrix = matrix.orthonormalize();
        return matrix.getMatrix(0, matrix.elements.length - 1, this.columndimension, matrix.columndimension - 1);
    }

    public final Matrix appendColumns(Matrix matrix) {
        if (this.elements.length != matrix.elements.length) {
            throw new IllegalArgumentException(ERR_MATRIX_DIMENSIONS);
        }
        Matrix matrix2 = new Matrix(this.elements.length, this.columndimension + matrix.columndimension);
        for (int i = 0; i < matrix2.columndimension; ++i) {
            if (i < this.columndimension) {
                matrix2.setCol(i, this.getCol(i));
                continue;
            }
            matrix2.setCol(i, matrix.getCol(i - this.columndimension));
        }
        return matrix2;
    }

    public final Matrix orthonormalize() {
        Matrix matrix = this.copy();
        for (int i = 1; i < this.columndimension; ++i) {
            Vector vector = this.getCol(i);
            Vector vector2 = new Vector(this.elements.length);
            for (int j = 0; j < i; ++j) {
                Vector vector3 = matrix.getCol(j);
                double d = vector.transposeTimes(vector3) / vector3.transposeTimes(vector3);
                vector2.plusTimesEquals(vector3, d);
            }
            Vector vector4 = vector.minus(vector2);
            matrix.setCol(i, vector4);
        }
        matrix.normalizeColumns();
        return matrix;
    }

    public final Matrix cheatToAvoidSingularity(double d) {
        Matrix matrix = this.copy();
        int n = 0;
        while (n < matrix.columndimension && n < matrix.elements.length) {
            double[] dArray = matrix.elements[n];
            int n2 = n++;
            dArray[n2] = dArray[n2] + d;
        }
        return matrix;
    }

    public static final Matrix read(BufferedReader bufferedReader) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(true);
        DoubleArray doubleArray = new DoubleArray();
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            doubleArray.add(FormatUtil.parseDouble(streamTokenizer.sval));
        } while (streamTokenizer.nextToken() == -3);
        int n2 = doubleArray.size();
        double[] dArray = doubleArray.toArray();
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        arrayList.add(dArray);
        while (streamTokenizer.nextToken() == -3) {
            dArray = new double[n2];
            arrayList.add(dArray);
            n = 0;
            do {
                if (n >= n2) {
                    throw new IOException("Row " + doubleArray.size() + " is too long.");
                }
                dArray[n++] = FormatUtil.parseDouble(streamTokenizer.sval);
            } while (streamTokenizer.nextToken() == -3);
            if (n >= n2) continue;
            throw new IOException("Row " + doubleArray.size() + " is too short.");
        }
        n = arrayList.size();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = (double[])arrayList.get(i);
        }
        return new Matrix(dArrayArray);
    }

    protected void checkMatrixDimensions(Matrix matrix) {
        if (matrix.getRowDimensionality() != this.getRowDimensionality() || matrix.getColumnDimensionality() != this.getColumnDimensionality()) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode((Object[])this.elements);
        n = 31 * n + this.elements.length;
        n = 31 * n + this.columndimension;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix matrix = (Matrix)object;
        if (this.elements.length != matrix.elements.length) {
            return false;
        }
        if (this.columndimension != matrix.columndimension) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.columndimension; ++j) {
                if (this.elements[i][j] == matrix.elements[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean almostEquals(Object object, double d) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix matrix = (Matrix)object;
        if (this.elements.length != matrix.elements.length) {
            return false;
        }
        if (this.columndimension != matrix.columndimension) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.columndimension; ++j) {
                if (!(Math.abs(this.elements[i][j] - matrix.elements[i][j]) > d)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean almostEquals(Object object) {
        return this.almostEquals(object, 0.001);
    }

    public String toString() {
        return FormatUtil.format(this);
    }
}

