/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import java.util.Collection;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.contributors.IterableOperationContributor;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolObjectComparator;
import org.eclipse.epsilon.eol.types.NumberUtil;

public class OperatorExecutor
extends AbstractExecutor {
    private AST ast = null;
    private IEolContext context;

    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        this.ast = ast;
        this.context = context;
        String operator = ast.getText();
        AST operand1Ast = ast.getFirstChild();
        AST operand2Ast = operand1Ast.getNextSibling();
        Object operand1 = null;
        Object operand2 = null;
        if (this.isBooleanOperator(operator)) {
            if (operator.compareTo("and") == 0) {
                return this.and(operand1Ast, operand2Ast);
            }
            if (operator.compareTo("or") == 0) {
                return this.or(operand1Ast, operand2Ast);
            }
            if (operator.compareTo("xor") == 0) {
                return this.xor(operand1Ast, operand2Ast);
            }
            if (operator.compareTo("implies") == 0) {
                return this.implies(operand1Ast, operand2Ast);
            }
            if (operator.compareTo("not") == 0) {
                return this.not(operand1Ast);
            }
        } else {
            operand1 = context.getExecutorFactory().executeAST(operand1Ast, context);
            if (operand2Ast != null) {
                operand2 = context.getExecutorFactory().executeAST(operand2Ast, context);
            }
            if (operator.compareTo("+") == 0) {
                return this.add(operand1, operand2);
            }
            if (operator.compareTo("-") == 0) {
                if (operand2 != null) {
                    return this.subtract(operand1, operand2);
                }
                return this.negative(operand1);
            }
            if (operator.compareTo("*") == 0) {
                return this.multiply(operand1, operand2);
            }
            if (operator.compareTo("/") == 0) {
                return this.divide(operand1, operand2);
            }
            if (operator.compareTo("<") == 0) {
                return this.lessThan(operand1, operand2);
            }
            if (operator.compareTo(">") == 0) {
                return this.greaterThan(operand1, operand2);
            }
            if (operator.compareTo("=") == 0) {
                return this.equals(operand1, operand2);
            }
            if (operator.compareTo("==") == 0) {
                return this.equals(operand1, operand2);
            }
            if (operator.compareTo("<>") == 0) {
                return !this.equals(operand1, operand2);
            }
            if (operator.compareTo(">=") == 0) {
                return this.greaterEqualThan(operand1, operand2);
            }
            if (operator.compareTo("<=") == 0) {
                return this.lessEqualThan(operand1, operand2);
            }
        }
        return null;
    }

    private Object negative(Object o) {
        if (o instanceof Number) {
            return NumberUtil.negative((Number)o);
        }
        return o;
    }

    private Object add(Object o1, Object o2) {
        if (o1 instanceof Number && o2 instanceof Number) {
            return NumberUtil.add((Number)o1, (Number)o2);
        }
        if (o1 instanceof Collection && o2 instanceof Collection) {
            return EolCollectionType.join((Collection)o1, (Collection)o2);
        }
        PrettyPrinterManager prettyPrinterManager = this.context.getPrettyPrinterManager();
        return String.valueOf(prettyPrinterManager.print(o1)) + prettyPrinterManager.print(o2);
    }

    private Object subtract(Object o1, Object o2) {
        if (o1 instanceof Number && o2 instanceof Number) {
            return NumberUtil.subtract((Number)o1, (Number)o2);
        }
        if (o1 instanceof Collection && o2 instanceof Collection) {
            return new IterableOperationContributor((Collection)o1).excludingAll((Collection)o2);
        }
        return null;
    }

    private Object multiply(Object o1, Object o2) {
        if (o1 instanceof Number && o2 instanceof Number) {
            return NumberUtil.multiply((Number)o1, (Number)o2);
        }
        return new Integer(0);
    }

    private Object divide(Object o1, Object o2) throws EolRuntimeException {
        if (o1 instanceof Number && o2 instanceof Number) {
            return NumberUtil.divide((Number)o1, (Number)o2);
        }
        throw new EolRuntimeException("Cannot divide " + this.context.getPrettyPrinterManager().toString(o1) + " by " + this.context.getPrettyPrinterManager().toString(o2));
    }

    public boolean greaterThan(Object o1, Object o2) {
        if (o1 instanceof Number && o2 instanceof Number) {
            return NumberUtil.greaterThan((Number)o1, (Number)o2);
        }
        return false;
    }

    public boolean lessThan(Object o1, Object o2) {
        if (o1 instanceof Number && o2 instanceof Number) {
            return NumberUtil.lessThan((Number)o1, (Number)o2);
        }
        return false;
    }

    public boolean equals(Object o1, Object o2) {
        return EolObjectComparator.equals(o1, o2);
    }

    public boolean greaterEqualThan(Object o1, Object o2) {
        return this.greaterThan(o1, o2) || this.equals(o1, o2);
    }

    public boolean lessEqualThan(Object o1, Object o2) {
        return this.lessThan(o1, o2) || this.equals(o1, o2);
    }

    public boolean and(AST operand1Ast, AST operand2Ast) throws EolRuntimeException {
        Object o1 = this.context.getExecutorFactory().executeAST(operand1Ast, this.context);
        if (o1 instanceof Boolean) {
            Boolean b1 = (Boolean)o1;
            if (!b1.booleanValue()) {
                return false;
            }
            Object o2 = this.context.getExecutorFactory().executeAST(operand2Ast, this.context);
            if (o2 instanceof Boolean) {
                return (Boolean)o2;
            }
            throw new EolRuntimeException("Operator 'and' applies only to operands of type Boolean", this.ast);
        }
        throw new EolRuntimeException("Operator 'and' applies only to operands of type Boolean", this.ast);
    }

    public boolean or(AST operand1Ast, AST operand2Ast) throws EolRuntimeException {
        Object o1 = this.context.getExecutorFactory().executeAST(operand1Ast, this.context);
        if (o1 instanceof Boolean) {
            Boolean b1 = (Boolean)o1;
            if (b1.booleanValue()) {
                return true;
            }
            Object o2 = this.context.getExecutorFactory().executeAST(operand2Ast, this.context);
            if (o2 instanceof Boolean) {
                return (Boolean)o2;
            }
            throw new EolRuntimeException("Operator 'or' applies only to operands of type Boolean", this.ast);
        }
        throw new EolRuntimeException("Operator 'or' applies only to operands of type Boolean", this.ast);
    }

    public boolean implies(AST operand1Ast, AST operand2Ast) throws EolRuntimeException {
        Object o1 = this.context.getExecutorFactory().executeAST(operand1Ast, this.context);
        if (o1 instanceof Boolean) {
            Boolean b1 = (Boolean)o1;
            if (!b1.booleanValue()) {
                return true;
            }
            Object o2 = this.context.getExecutorFactory().executeAST(operand2Ast, this.context);
            if (o2 instanceof Boolean) {
                return (Boolean)o2 != false && (Boolean)o1 != false;
            }
            throw new EolRuntimeException("Operator 'implies' applies only to operands of type Boolean", this.ast);
        }
        throw new EolRuntimeException("Operator 'implies' applies only to operands of type Boolean", this.ast);
    }

    public boolean xor(AST operand1Ast, AST operand2Ast) throws EolRuntimeException {
        Object o1 = this.context.getExecutorFactory().executeAST(operand1Ast, this.context);
        Object o2 = this.context.getExecutorFactory().executeAST(operand2Ast, this.context);
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return (Boolean)o1 ^ (Boolean)o2;
        }
        throw new EolRuntimeException("Operator 'xor' applies only to Booleans", this.ast);
    }

    public Boolean not(AST operand1Ast) throws EolRuntimeException {
        Object o1 = this.context.getExecutorFactory().executeAST(operand1Ast, this.context);
        if (o1 instanceof Boolean) {
            return (Boolean)o1 == false;
        }
        throw new EolRuntimeException("Operator 'not' applies only to Booleans", this.ast);
    }

    public boolean isBooleanOperator(String operator) {
        return operator.equals("and") || operator.equals("or") || operator.equals("xor") || operator.equals("not") || operator.equals("implies");
    }
}

