/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.RevisionUtils;
import weka.estimators.ConditionalEstimator;
import weka.estimators.DiscreteEstimator;
import weka.estimators.Estimator;
import weka.estimators.KernelEstimator;

public class DKConditionalEstimator
implements ConditionalEstimator {
    private KernelEstimator[] m_Estimators;
    private DiscreteEstimator m_Weights;

    public DKConditionalEstimator(int numSymbols, double precision) {
        this.m_Estimators = new KernelEstimator[numSymbols];
        int i = 0;
        while (i < numSymbols) {
            this.m_Estimators[i] = new KernelEstimator(precision);
            ++i;
        }
        this.m_Weights = new DiscreteEstimator(numSymbols, true);
    }

    @Override
    public void addValue(double data, double given, double weight) {
        this.m_Estimators[(int)data].addValue(given, weight);
        this.m_Weights.addValue((int)data, weight);
    }

    @Override
    public Estimator getEstimator(double given) {
        DiscreteEstimator result = new DiscreteEstimator(this.m_Estimators.length, false);
        int i = 0;
        while (i < this.m_Estimators.length) {
            ((Estimator)result).addValue(i, this.m_Weights.getProbability(i) * this.m_Estimators[i].getProbability(given));
            ++i;
        }
        return result;
    }

    @Override
    public double getProbability(double data, double given) {
        return this.getEstimator(given).getProbability(data);
    }

    public String toString() {
        String result = "DK Conditional Estimator. " + this.m_Estimators.length + " sub-estimators:\n";
        int i = 0;
        while (i < this.m_Estimators.length) {
            result = String.valueOf(result) + "Sub-estimator " + i + ": " + this.m_Estimators[i];
            ++i;
        }
        result = String.valueOf(result) + "Weights of each estimator given by " + this.m_Weights;
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] argv) {
        try {
            int currentB;
            int currentA;
            if (argv.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            int maxA = currentA = Integer.parseInt(argv[0]);
            int maxB = currentB = Integer.parseInt(argv[1]);
            int i = 2;
            while (i < argv.length - 1) {
                currentA = Integer.parseInt(argv[i]);
                currentB = Integer.parseInt(argv[i + 1]);
                if (currentA > maxA) {
                    maxA = currentA;
                }
                if (currentB > maxB) {
                    maxB = currentB;
                }
                i += 2;
            }
            DKConditionalEstimator newEst = new DKConditionalEstimator(maxA + 1, 1.0);
            int i2 = 0;
            while (i2 < argv.length - 1) {
                currentA = Integer.parseInt(argv[i2]);
                currentB = Integer.parseInt(argv[i2 + 1]);
                System.out.println(newEst);
                System.out.println("Prediction for " + currentA + '|' + currentB + " = " + newEst.getProbability(currentA, currentB));
                newEst.addValue(currentA, currentB, 1.0);
                i2 += 2;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

