/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks.emf;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.workflow.tasks.EpsilonTask;
import org.eclipse.epsilon.workflow.tasks.ShutdownProjectRepositoryListener;

public class LoadEmfModelTask
extends EpsilonTask {
    protected String name;
    protected String alias;
    protected File modelFile;
    protected String modelUri;
    protected File metamodelFile;
    protected String metamodelUri;
    protected boolean read = true;
    protected boolean store = false;
    protected boolean expand = false;

    @Override
    public void executeImpl() throws BuildException {
        ShutdownProjectRepositoryListener.activate(this.getProject(), this.getProjectRepository());
        EmfModel model = this.createEmfModel();
        StringProperties properties = new StringProperties();
        properties.put("name", String.valueOf(this.name));
        properties.put("aliases", String.valueOf(this.alias));
        properties.put("isMetamodelFileBased", String.valueOf(this.metamodelUri == null));
        properties.put("readOnLoad", String.valueOf(this.read));
        properties.put("storeOnDisposal", String.valueOf(this.store));
        properties.put("expand", String.valueOf(this.expand));
        if (this.metamodelUri != null) {
            properties.put("metamodelUri", String.valueOf(this.metamodelUri));
        }
        if (this.modelFile != null && this.modelUri != null) {
            throw new BuildException("Only one of modelFile or modelUri may be used");
        }
        if (this.modelUri != null) {
            properties.put("modelUri", this.modelUri);
        } else {
            properties.put("modelUri", this.convertFileToUri(this.modelFile));
        }
        if (this.metamodelFile != null) {
            properties.put("fileBasedMetamodelUri", this.convertFileToUri(this.metamodelFile));
        }
        try {
            model.load(properties, null);
            this.getProjectRepository().addModel(model);
        }
        catch (EolModelLoadingException e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private URI convertFileToUri(File file) {
        return file == null ? null : URI.createFileURI(file.getAbsolutePath());
    }

    protected EmfModel createEmfModel() {
        return new EmfModel();
    }

    public boolean isExpand() {
        return this.expand;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        System.out.println("[WARNING] Attribute 'alias' is deprecated. Please use 'aliases' instead.");
        this.alias = alias;
    }

    public void setAliases(String aliases) {
        this.alias = aliases;
    }

    public String getAliases() {
        return this.alias;
    }

    public File getModelFile() {
        return this.modelFile;
    }

    public void setModelFile(File modelFile) {
        this.modelFile = modelFile;
    }

    public String getModelUri() {
        return this.modelUri;
    }

    public void setModelUri(String modelUri) {
        this.modelUri = modelUri;
    }

    public File getMetamodelFile() {
        return this.metamodelFile;
    }

    public void setMetamodelFile(File metamodelFile) {
        this.metamodelFile = metamodelFile;
    }

    public String getMetamodelUri() {
        return this.metamodelUri;
    }

    public void setMetamodelUri(String metamodelUri) {
        this.metamodelUri = metamodelUri;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean isStore() {
        return this.store;
    }

    public void setStore(boolean store) {
        this.store = store;
    }
}

