/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.LinkageMethod;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. C. Gower", title="A comparison of some methods of cluster analysis", booktitle="Biometrics (1967)", url="http://www.jstor.org/stable/10.2307/2528417")
@Alias(value={"wpgmc", "WPGMC", "weighted-centroid"})
public class MedianLinkageMethod
implements LinkageMethod {
    public static final MedianLinkageMethod STATIC = new MedianLinkageMethod();

    @Deprecated
    public MedianLinkageMethod() {
    }

    @Override
    public double combine(int n, double d, int n2, double d2, int n3, double d3) {
        return 0.5 * (d + d2) - 0.25 * d3;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MedianLinkageMethod makeInstance() {
            return STATIC;
        }
    }
}

