/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.clustering.AbstractProjectedClustering;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.SubspaceClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.Subspace;
import de.lmu.ifi.dbs.elki.data.model.SubspaceModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

@Title(value="PROCLUS: PROjected CLUStering")
@Description(value="Algorithm to find subspace clusters in high dimensional spaces.")
@Reference(authors="C. C. Aggarwal, C. Procopiuc, J. L. Wolf, P. S. Yu, J. S. Park", title="Fast Algorithms for Projected Clustering", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="http://dx.doi.org/10.1145/304181.304188")
public class PROCLUS<V extends NumberVector>
extends AbstractProjectedClustering<Clustering<SubspaceModel>, V>
implements SubspaceClusteringAlgorithm<SubspaceModel> {
    private static final Logging LOG = Logging.getLogger(PROCLUS.class);
    private int m_i;
    private RandomFactory rnd;

    public PROCLUS(int n, int n2, int n3, int n4, RandomFactory randomFactory) {
        super(n, n2, n3);
        this.m_i = n4;
        this.rnd = randomFactory;
    }

    public Clustering<SubspaceModel> run(Database database, Relation<V> relation) {
        Object object;
        Object object2;
        DistanceQuery distanceQuery = this.getDistanceQuery(database);
        RangeQuery rangeQuery = database.getRangeQuery(distanceQuery, new Object[0]);
        Random random = this.rnd.getSingleThreadedRandom();
        if (RelationUtil.dimensionality(relation) < this.l) {
            throw new IllegalStateException("Dimensionality of data < parameter l! (" + RelationUtil.dimensionality(relation) + " < " + this.l + ")");
        }
        if (LOG.isVerbose()) {
            LOG.verbose("1. Initialization phase...");
        }
        int n = Math.min(relation.size(), this.k_i * this.k);
        ModifiableDBIDs modifiableDBIDs = DBIDUtil.randomSample(relation.getDBIDs(), n, random);
        int n2 = Math.min(relation.size(), this.m_i * this.k);
        ArrayDBIDs arrayDBIDs = this.greedy(distanceQuery, modifiableDBIDs, n2, random);
        if (LOG.isDebugging()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\n');
            stringBuilder.append("sampleSize ").append(n).append('\n');
            stringBuilder.append("sampleSet ").append(modifiableDBIDs).append('\n');
            stringBuilder.append("medoidSize ").append(n2).append('\n');
            stringBuilder.append("m ").append(arrayDBIDs).append('\n');
            LOG.debugFine(stringBuilder.toString());
        }
        if (LOG.isVerbose()) {
            LOG.verbose("2. Iterative phase...");
        }
        double d = Double.POSITIVE_INFINITY;
        ArrayDBIDs arrayDBIDs2 = null;
        DBIDs dBIDs = null;
        ArrayDBIDs arrayDBIDs3 = this.initialSet(arrayDBIDs, this.k, random);
        if (LOG.isDebugging()) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append('\n');
            ((StringBuilder)object2).append("m_c ").append(arrayDBIDs3).append('\n');
            LOG.debugFine(((StringBuilder)object2).toString());
        }
        object2 = LOG.isVerbose() ? new IndefiniteProgress("Current number of clusters:", LOG) : null;
        ArrayList<PROCLUSCluster> arrayList = null;
        for (int i = 0; i < 10; ++i) {
            object = this.findDimensions(arrayDBIDs3, relation, distanceQuery, rangeQuery);
            arrayList = this.assignPoints(arrayDBIDs3, (long[][])object, relation);
            double d2 = this.evaluateClusters(arrayList, (long[][])object, relation);
            if (d2 < d) {
                i = 0;
                d = d2;
                arrayDBIDs2 = arrayDBIDs3;
                dBIDs = this.computeBadMedoids(arrayDBIDs3, arrayList, (int)((double)relation.size() * 0.1 / (double)this.k));
            }
            arrayDBIDs3 = this.computeM_current(arrayDBIDs, arrayDBIDs2, dBIDs, random);
            if (object2 == null) continue;
            ((AbstractProgress)object2).setProcessed(arrayList.size(), LOG);
        }
        LOG.setCompleted((IndefiniteProgress)object2);
        if (LOG.isVerbose()) {
            LOG.verbose("3. Refinement phase...");
        }
        object = this.findDimensions(arrayList, relation);
        List<PROCLUSCluster> list = this.finalAssignment((List<Pair<Vector, long[]>>)object, relation);
        int n3 = 1;
        Clustering<SubspaceModel> clustering = new Clustering<SubspaceModel>("ProClus clustering", "proclus-clustering");
        for (PROCLUSCluster pROCLUSCluster : list) {
            Cluster<SubspaceModel> cluster = new Cluster<SubspaceModel>(pROCLUSCluster.objectIDs);
            cluster.setModel(new SubspaceModel(new Subspace(pROCLUSCluster.getDimensions()), pROCLUSCluster.centroid));
            cluster.setName("cluster_" + n3++);
            clustering.addToplevelCluster(cluster);
        }
        return clustering;
    }

    private ArrayDBIDs greedy(DistanceQuery<V> distanceQuery, DBIDs dBIDs, int n, Random random) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(n);
        ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray(dBIDs);
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs2.iter();
        DBIDVar dBIDVar = DBIDUtil.newVar();
        int n2 = arrayModifiableDBIDs2.size();
        int n3 = random.nextInt(n2);
        arrayModifiableDBIDs2.assignVar(n3, dBIDVar);
        arrayModifiableDBIDs.add(dBIDVar);
        if (LOG.isDebugging()) {
            LOG.debugFiner("medoids " + arrayModifiableDBIDs.toString());
        }
        arrayModifiableDBIDs2.swap(n3, n2 - 1);
        --n2;
        int n4 = -1;
        double d = Double.NEGATIVE_INFINITY;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(arrayModifiableDBIDs2, 3);
        dBIDArrayMIter.seek(0);
        while (dBIDArrayMIter.getOffset() < n2) {
            double d2 = distanceQuery.distance((DBIDRef)dBIDArrayMIter, (DBIDRef)dBIDVar);
            writableDoubleDataStore.putDouble(dBIDArrayMIter, d2);
            if (d2 > d) {
                d = d2;
                n4 = dBIDArrayMIter.getOffset();
            }
            dBIDArrayMIter.advance();
        }
        for (int i = 1; i < n; ++i) {
            arrayModifiableDBIDs2.assignVar(n4, dBIDVar);
            arrayModifiableDBIDs.add(dBIDVar);
            arrayModifiableDBIDs2.swap(n4, n2 - 1);
            --n2;
            n4 = -1;
            d = Double.NEGATIVE_INFINITY;
            dBIDArrayMIter.seek(0);
            while (dBIDArrayMIter.getOffset() < n2) {
                double d3;
                double d4 = distanceQuery.distance((DBIDRef)dBIDArrayMIter, (DBIDRef)dBIDVar);
                double d5 = d4 < (d3 = writableDoubleDataStore.doubleValue(dBIDArrayMIter)) ? d4 : d3;
                writableDoubleDataStore.putDouble(dBIDArrayMIter, d5);
                if (d5 > d) {
                    d = d5;
                    n4 = dBIDArrayMIter.getOffset();
                }
                dBIDArrayMIter.advance();
            }
            if (!LOG.isDebugging()) continue;
            LOG.debugFiner("medoids " + arrayModifiableDBIDs.toString());
        }
        return arrayModifiableDBIDs;
    }

    private ArrayDBIDs initialSet(DBIDs dBIDs, int n, Random random) {
        return DBIDUtil.ensureArray(DBIDUtil.randomSample(dBIDs, n, random));
    }

    private ArrayDBIDs computeM_current(DBIDs dBIDs, DBIDs dBIDs2, DBIDs dBIDs3, Random random) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs);
        arrayModifiableDBIDs.removeDBIDs(dBIDs2);
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray();
        DBIDIter dBIDIter = dBIDs2.iter();
        while (dBIDIter.valid()) {
            if (dBIDs3.contains(dBIDIter)) {
                int n = arrayModifiableDBIDs2.size();
                while (arrayModifiableDBIDs2.size() == n) {
                    arrayModifiableDBIDs2.add(dBIDArrayMIter.seek(random.nextInt(arrayModifiableDBIDs.size())));
                    dBIDArrayMIter.remove();
                }
            } else {
                arrayModifiableDBIDs2.add(dBIDIter);
            }
            dBIDIter.advance();
        }
        return arrayModifiableDBIDs2;
    }

    private DataStore<DoubleDBIDList> getLocalities(DBIDs dBIDs, Relation<V> relation, DistanceQuery<V> distanceQuery, RangeQuery<V> rangeQuery) {
        WritableDataStore<DoubleDBIDList> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 3, DoubleDBIDList.class);
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d = Double.POSITIVE_INFINITY;
            Object object = dBIDs.iter();
            while (object.valid()) {
                double d2;
                if (!DBIDUtil.equal(dBIDIter, (DBIDRef)object) && (d2 = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)object)) < d) {
                    d = d2;
                }
                object.advance();
            }
            assert (d != Double.POSITIVE_INFINITY);
            object = rangeQuery.getRangeForDBID(dBIDIter, d);
            writableDataStore.put(dBIDIter, (DoubleDBIDList)object);
            dBIDIter.advance();
        }
        return writableDataStore;
    }

    private long[][] findDimensions(ArrayDBIDs arrayDBIDs, Relation<V> relation, DistanceQuery<V> distanceQuery, RangeQuery<V> rangeQuery) {
        Object object;
        Object object2;
        DataStore<DoubleDBIDList> dataStore = this.getLocalities(arrayDBIDs, relation, distanceQuery, rangeQuery);
        int n = RelationUtil.dimensionality(relation);
        double[][] dArrayArray = new double[arrayDBIDs.size()][];
        int n2 = 0;
        Object object3 = arrayDBIDs.iter();
        while (object3.valid()) {
            object2 = (NumberVector)relation.get((DBIDRef)object3);
            object = dataStore.get((DBIDRef)object3);
            double[] dArray = new double[n];
            DoubleDBIDListIter doubleDBIDListIter = object.iter();
            while (doubleDBIDListIter.valid()) {
                NumberVector numberVector = (NumberVector)relation.get(doubleDBIDListIter);
                for (int i = 0; i < n; ++i) {
                    int n3 = i;
                    dArray[n3] = dArray[n3] + Math.abs(object2.doubleValue(i) - numberVector.doubleValue(i));
                }
                doubleDBIDListIter.advance();
            }
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                dArray[n5] = dArray[n5] / (double)object.size();
            }
            dArrayArray[n2] = dArray;
            object3.advance();
            ++n2;
        }
        object3 = new long[arrayDBIDs.size()][(n - 1 >> 6) + 1];
        object2 = new ArrayList();
        for (n2 = 0; n2 < arrayDBIDs.size(); ++n2) {
            int n6;
            object = dArrayArray[n2];
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                d += object[i];
            }
            d /= (double)n;
            double d2 = 0.0;
            for (n6 = 0; n6 < n; ++n6) {
                reference var17_27 = object[n6] - d;
                d2 += var17_27 * var17_27;
            }
            d2 /= (double)(n - 1);
            d2 = Math.sqrt(d2);
            for (n6 = 0; n6 < n; ++n6) {
                object2.add(new DoubleIntInt((double)((object[n6] - d) / d2), n2, n6));
            }
        }
        Collections.sort(object2);
        int n7 = Math.max(this.k * this.l, 2);
        for (int i = 0; i < n7; ++i) {
            DoubleIntInt doubleIntInt = (DoubleIntInt)object2.get(i);
            Object object4 = object3[doubleIntInt.dimi];
            BitsUtil.setI((long[])object4, doubleIntInt.dimj);
            if (!LOG.isDebugging()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\n');
            stringBuilder.append("z_ij ").append(doubleIntInt).append('\n');
            stringBuilder.append("D_i ").append(BitsUtil.toString((long[])object4)).append('\n');
            LOG.debugFiner(stringBuilder.toString());
        }
        return object3;
    }

    private List<Pair<Vector, long[]>> findDimensions(ArrayList<PROCLUSCluster> arrayList, Relation<V> relation) {
        Object object;
        Object object2;
        double[] dArray;
        int n = RelationUtil.dimensionality(relation);
        int n2 = arrayList.size();
        double[][] dArrayArray = new double[n2][];
        for (int i = 0; i < n2; ++i) {
            PROCLUSCluster pROCLUSCluster = arrayList.get(i);
            dArray = new double[n];
            DBIDMIter dBIDMIter = pROCLUSCluster.objectIDs.iter();
            while (dBIDMIter.valid()) {
                object2 = (NumberVector)relation.get(dBIDMIter);
                for (int j = 0; j < n; ++j) {
                    int n3 = j;
                    dArray[n3] = dArray[n3] + Math.abs(pROCLUSCluster.centroid.doubleValue(j) - object2.doubleValue(j));
                }
                dBIDMIter.advance();
            }
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                dArray[n5] = dArray[n5] / (double)pROCLUSCluster.objectIDs.size();
            }
            dArrayArray[i] = dArray;
        }
        ArrayList<DoubleIntInt> arrayList2 = new ArrayList<DoubleIntInt>();
        for (int i = 0; i < n2; ++i) {
            int n6;
            dArray = dArrayArray[i];
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += dArray[j];
            }
            d /= (double)n;
            double d2 = 0.0;
            for (n6 = 0; n6 < n; ++n6) {
                double d3 = dArray[n6] - d;
                d2 += d3 * d3;
            }
            d2 /= (double)(n - 1);
            d2 = Math.sqrt(d2);
            for (n6 = 0; n6 < n; ++n6) {
                arrayList2.add(new DoubleIntInt((dArray[n6] - d) / d2, i, n6));
            }
        }
        Collections.sort(arrayList2);
        long[][] lArray = new long[n2][(n - 1 >> 6) + 1];
        int n7 = Math.max(this.k * this.l, 2);
        for (int i = 0; i < n7; ++i) {
            object2 = (DoubleIntInt)arrayList2.get(i);
            long[] lArray2 = lArray[((DoubleIntInt)object2).dimi];
            BitsUtil.setI(lArray2, ((DoubleIntInt)object2).dimj);
            if (!LOG.isDebugging()) continue;
            object = new StringBuilder();
            ((StringBuilder)object).append('\n');
            ((StringBuilder)object).append("z_ij ").append(object2).append('\n');
            ((StringBuilder)object).append("D_i ").append(BitsUtil.toString(lArray2)).append('\n');
            LOG.debugFiner(((StringBuilder)object).toString());
        }
        ArrayList<Pair<Vector, long[]>> arrayList3 = new ArrayList<Pair<Vector, long[]>>();
        for (int i = 0; i < n2; ++i) {
            long[] lArray3 = lArray[i];
            if (lArray3 == null) continue;
            object = arrayList.get(i);
            arrayList3.add(new Pair<Vector, long[]>(((PROCLUSCluster)object).centroid, lArray3));
        }
        return arrayList3;
    }

    private ArrayList<PROCLUSCluster> assignPoints(ArrayDBIDs arrayDBIDs, long[][] lArray, Relation<V> relation) {
        ModifiableDBIDs[] modifiableDBIDsArray = new ModifiableDBIDs[lArray.length];
        for (int i = 0; i < arrayDBIDs.size(); ++i) {
            modifiableDBIDsArray[i] = DBIDUtil.newHashSet();
        }
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            Object object2;
            NumberVector numberVector = (NumberVector)relation.get((DBIDRef)object);
            double d = Double.NaN;
            int n = -1;
            int n2 = 0;
            dBIDArrayIter.seek(0);
            while (dBIDArrayIter.valid()) {
                object2 = (NumberVector)relation.get(dBIDArrayIter);
                double d2 = this.manhattanSegmentalDistance(numberVector, (NumberVector)object2, lArray[n2]);
                if (!(d <= d2)) {
                    d = d2;
                    n = n2;
                }
                dBIDArrayIter.advance();
                ++n2;
            }
            assert (n >= 0);
            object2 = modifiableDBIDsArray[n];
            object2.add((DBIDRef)object);
            object.advance();
        }
        object = new ArrayList(arrayDBIDs.size());
        for (int i = 0; i < lArray.length; ++i) {
            ModifiableDBIDs modifiableDBIDs = modifiableDBIDsArray[i];
            if (!modifiableDBIDs.isEmpty()) {
                long[] lArray2 = lArray[i];
                Centroid centroid = Centroid.make(relation, modifiableDBIDs);
                ((ArrayList)object).add(new PROCLUSCluster(modifiableDBIDs, lArray2, centroid));
                continue;
            }
            ((ArrayList)object).add(null);
        }
        if (LOG.isDebugging()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\n');
            stringBuilder.append("clusters ").append(object).append('\n');
            LOG.debugFine(stringBuilder.toString());
        }
        return object;
    }

    private List<PROCLUSCluster> finalAssignment(List<Pair<Vector, long[]>> list, Relation<V> relation) {
        HashMap<Integer, HashSetModifiableDBIDs> hashMap = new HashMap<Integer, HashSetModifiableDBIDs>();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(i, DBIDUtil.newHashSet());
        }
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            NumberVector numberVector = (NumberVector)relation.get((DBIDRef)object);
            double d = Double.POSITIVE_INFINITY;
            int n = -1;
            for (int i = 0; i < list.size(); ++i) {
                Pair<Vector, long[]> pair = list.get(i);
                Vector vector = (Vector)pair.first;
                long[] lArray = (long[])pair.second;
                double d2 = this.manhattanSegmentalDistance(numberVector, vector, lArray);
                if (n >= 0 && !(d2 < d)) continue;
                d = d2;
                n = i;
            }
            assert (d >= 0.0);
            ModifiableDBIDs modifiableDBIDs = (ModifiableDBIDs)hashMap.get(n);
            modifiableDBIDs.add((DBIDRef)object);
            object.advance();
        }
        object = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            ModifiableDBIDs modifiableDBIDs = (ModifiableDBIDs)hashMap.get(i);
            if (modifiableDBIDs.isEmpty()) continue;
            long[] lArray = (long[])list.get((int)i).second;
            Centroid centroid = Centroid.make(relation, modifiableDBIDs);
            object.add(new PROCLUSCluster(modifiableDBIDs, lArray, centroid));
        }
        if (LOG.isDebugging()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\n');
            stringBuilder.append("clusters ").append(object).append('\n');
            LOG.debugFine(stringBuilder.toString());
        }
        return object;
    }

    private double manhattanSegmentalDistance(NumberVector numberVector, NumberVector numberVector2, long[] lArray) {
        double d = 0.0;
        int n = 0;
        int n2 = BitsUtil.nextSetBit(lArray, 0);
        while (n2 >= 0) {
            d += Math.abs(numberVector.doubleValue(n2) - numberVector2.doubleValue(n2));
            ++n;
            n2 = BitsUtil.nextSetBit(lArray, n2 + 1);
        }
        return d /= (double)n;
    }

    private double evaluateClusters(ArrayList<PROCLUSCluster> arrayList, long[][] lArray, Relation<V> relation) {
        double d = 0.0;
        for (int i = 0; i < lArray.length; ++i) {
            PROCLUSCluster pROCLUSCluster = arrayList.get(i);
            Vector vector = pROCLUSCluster.centroid;
            long[] lArray2 = lArray[i];
            double d2 = 0.0;
            int n = BitsUtil.nextSetBit(lArray2, 0);
            while (n >= 0) {
                d2 += this.avgDistance(vector, pROCLUSCluster.objectIDs, relation, n);
                n = BitsUtil.nextSetBit(lArray2, n + 1);
            }
            d += (double)pROCLUSCluster.objectIDs.size() * (d2 /= (double)lArray.length);
        }
        return d / (double)relation.size();
    }

    private double avgDistance(Vector vector, DBIDs dBIDs, Relation<V> relation, int n) {
        Mean mean = new Mean();
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
            mean.put(Math.abs(vector.doubleValue(n) - numberVector.doubleValue(n)));
            dBIDIter.advance();
        }
        return mean.getMean();
    }

    private DBIDs computeBadMedoids(ArrayDBIDs arrayDBIDs, ArrayList<PROCLUSCluster> arrayList, int n) {
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(arrayDBIDs.size());
        int n2 = 0;
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            PROCLUSCluster pROCLUSCluster = arrayList.get(n2);
            if (pROCLUSCluster == null || pROCLUSCluster.objectIDs.size() < n) {
                hashSetModifiableDBIDs.add(dBIDArrayIter);
            }
            dBIDArrayIter.advance();
            ++n2;
        }
        return hashSetModifiableDBIDs;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractProjectedClustering.Parameterizer {
        public static final OptionID M_I_ID = new OptionID("proclus.mi", "The multiplier for the initial number of medoids.");
        public static final OptionID SEED_ID = new OptionID("proclus.seed", "The random number generator seed.");
        protected int m_i = -1;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            super.makeOptions(parameterization);
            this.configK(parameterization);
            this.configKI(parameterization);
            this.configL(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(M_I_ID, 10).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.m_i = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected PROCLUS<V> makeInstance() {
            return new PROCLUS(this.k, this.k_i, this.l, this.m_i, this.rnd);
        }
    }

    private class PROCLUSCluster {
        ModifiableDBIDs objectIDs;
        long[] dimensions;
        Vector centroid;

        public PROCLUSCluster(ModifiableDBIDs modifiableDBIDs, long[] lArray, Vector vector) {
            this.objectIDs = modifiableDBIDs;
            this.dimensions = lArray;
            this.centroid = vector;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Dimensions: [");
            boolean bl = false;
            int n = BitsUtil.nextSetBit(this.dimensions, 0);
            while (n >= 0) {
                if (bl) {
                    stringBuilder.append(',');
                } else {
                    bl = true;
                }
                stringBuilder.append(n);
                n = BitsUtil.nextSetBit(this.dimensions, n + 1);
            }
            stringBuilder.append(']');
            stringBuilder.append("\nCentroid: ").append(this.centroid);
            return stringBuilder.toString();
        }

        public long[] getDimensions() {
            return this.dimensions;
        }
    }

    private static class DoubleIntInt
    implements Comparable<DoubleIntInt> {
        protected double first;
        protected int dimi;
        protected int dimj;

        public DoubleIntInt(double d, int n, int n2) {
            this.first = d;
            this.dimi = n;
            this.dimj = n2;
        }

        @Override
        public int compareTo(DoubleIntInt doubleIntInt) {
            if (this.first < doubleIntInt.first) {
                return -1;
            }
            if (this.first > doubleIntInt.first) {
                return 1;
            }
            return 0;
        }
    }
}

