/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.cleaning;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class VectorDimensionalityFilter<V extends NumberVector>
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(VectorDimensionalityFilter.class);
    BundleMeta meta;
    int column = -1;
    int dim = -1;

    public VectorDimensionalityFilter(int n) {
        this.dim = n;
    }

    @Override
    public BundleMeta getMeta() {
        if (this.meta == null) {
            this.updateMeta();
        }
        return this.source.getMeta();
    }

    @Override
    public Object data(int n) {
        return this.source.data(n);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event event = this.source.nextEvent();
            switch (event) {
                case END_OF_STREAM: {
                    return event;
                }
                case META_CHANGED: {
                    this.meta = null;
                    return event;
                }
                case NEXT_OBJECT: {
                    if (this.meta == null) {
                        this.updateMeta();
                    }
                    if (this.column >= 0 && this.dim >= 0) {
                        NumberVector numberVector = (NumberVector)this.source.data(this.column);
                        if (numberVector == null) {
                            if (!LOG.isVeryVerbose()) continue block5;
                            LOG.veryverbose("Skipping null vector.");
                            continue block5;
                        }
                        if (numberVector.getDimensionality() != this.dim) {
                            if (!LOG.isVeryVerbose()) continue block5;
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Skipping vector of wrong dimensionality ");
                            stringBuilder.append(numberVector.getDimensionality());
                            stringBuilder.append(':');
                            for (int i = 0; i < this.meta.size(); ++i) {
                                stringBuilder.append(' ');
                                stringBuilder.append(this.source.data(i));
                            }
                            LOG.veryverbose(stringBuilder.toString());
                            continue block5;
                        }
                    }
                    return event;
                }
            }
        }
    }

    private void updateMeta() {
        this.meta = new BundleMeta();
        BundleMeta bundleMeta = this.source.getMeta();
        for (int i = 0; i < bundleMeta.size(); ++i) {
            SimpleTypeInformation simpleTypeInformation = (SimpleTypeInformation)bundleMeta.get(i);
            if (this.column < 0 && TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH.isAssignableFromType(simpleTypeInformation)) {
                VectorTypeInformation vectorTypeInformation;
                if (simpleTypeInformation instanceof VectorFieldTypeInformation) {
                    vectorTypeInformation = (VectorFieldTypeInformation)simpleTypeInformation;
                    if (this.dim != -1 && vectorTypeInformation.mindim() > this.dim) {
                        throw new AbortException("Would filter all vectors: minimum dimensionality " + vectorTypeInformation.mindim() + " > desired dimensionality " + this.dim);
                    }
                    if (this.dim != -1 && vectorTypeInformation.maxdim() < this.dim) {
                        throw new AbortException("Would filter all vectors: maximum dimensionality " + vectorTypeInformation.maxdim() + " < desired dimensionality " + this.dim);
                    }
                    if (this.dim == -1) {
                        this.dim = vectorTypeInformation.mindim();
                    }
                    if (vectorTypeInformation.mindim() == vectorTypeInformation.maxdim()) {
                        this.meta.add(vectorTypeInformation);
                        this.column = i;
                        continue;
                    }
                }
                vectorTypeInformation = (VectorTypeInformation)simpleTypeInformation;
                if (this.dim != -1) {
                    this.meta.add(new VectorFieldTypeInformation(FilterUtil.guessFactory(vectorTypeInformation), this.dim, this.dim, vectorTypeInformation.getSerializer()));
                } else {
                    LOG.warning("No dimensionality yet for column " + i);
                    this.meta.add(vectorTypeInformation);
                }
                this.column = i;
                continue;
            }
            this.meta.add(simpleTypeInformation);
        }
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        private static final OptionID DIM_P = new OptionID("filter.dim", "Dimensionality of vectors to retain.");
        int dim = -1;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)((IntParameter)new IntParameter(DIM_P).setOptional(true)).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            this.dim = parameterization.grab(intParameter) ? intParameter.intValue() : -1;
        }

        @Override
        protected VectorDimensionalityFilter<V> makeInstance() {
            return new VectorDimensionalityFilter(this.dim);
        }
    }
}

