/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.visualization.projections.AbstractSimpleProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;

public class Simple2D
extends AbstractSimpleProjection
implements Projection2D {
    private int dim1;
    private int dim2;

    public Simple2D(Projector projector, LinearScale[] linearScaleArray, int n, int n2) {
        super(projector, linearScaleArray);
        this.dim1 = n;
        this.dim2 = n2;
    }

    @Override
    public double[] fastProjectDataToRenderSpace(double[] dArray) {
        double d = (this.scales[this.dim1].getScaled(dArray[this.dim1]) - 0.5) * 100.0;
        double d2 = (this.scales[this.dim2].getScaled(dArray[this.dim2]) - 0.5) * -100.0;
        return new double[]{d, d2};
    }

    @Override
    public double[] fastProjectDataToRenderSpace(NumberVector numberVector) {
        double d = (this.scales[this.dim1].getScaled(numberVector.doubleValue(this.dim1)) - 0.5) * 100.0;
        double d2 = (this.scales[this.dim2].getScaled(numberVector.doubleValue(this.dim2)) - 0.5) * -100.0;
        return new double[]{d, d2};
    }

    @Override
    public double[] fastProjectDataToScaledSpace(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.scales[i].getScaled(dArray[i]);
        }
        return dArray2;
    }

    @Override
    public double[] fastProjectDataToScaledSpace(NumberVector numberVector) {
        int n = numberVector.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.scales[i].getScaled(numberVector.doubleValue(i));
        }
        return dArray;
    }

    @Override
    public double[] fastProjectScaledToRenderSpace(double[] dArray) {
        double d = (dArray[this.dim1] - 0.5) * 100.0;
        double d2 = (dArray[this.dim2] - 0.5) * -100.0;
        return new double[]{d, d2};
    }

    @Override
    public double[] fastProjectRenderToDataSpace(double d, double d2) {
        double[] dArray = new double[this.scales.length];
        for (int i = 0; i < this.scales.length; ++i) {
            dArray[i] = i == this.dim1 ? this.scales[i].getUnscaled(d * 0.01 + 0.5) : (i == this.dim2 ? this.scales[i].getUnscaled(d2 * -0.01 + 0.5) : this.scales[i].getUnscaled(0.5));
        }
        return dArray;
    }

    @Override
    public double[] fastProjectRenderToScaledSpace(double d, double d2) {
        double[] dArray = new double[this.scales.length];
        for (int i = 0; i < this.scales.length; ++i) {
            dArray[i] = i == this.dim1 ? d * 0.01 + 0.5 : (i == this.dim2 ? d2 * -0.01 + 0.5 : 0.5);
        }
        return dArray;
    }

    @Override
    public double[] fastProjectRelativeDataToRenderSpace(double[] dArray) {
        double d = this.scales[this.dim1].getRelativeScaled(dArray[this.dim1]) * 100.0;
        double d2 = this.scales[this.dim2].getRelativeScaled(dArray[this.dim2]) * -100.0;
        return new double[]{d, d2};
    }

    @Override
    public double[] fastProjectRelativeDataToRenderSpace(NumberVector numberVector) {
        double d = this.scales[this.dim1].getRelativeScaled(numberVector.doubleValue(this.dim1)) * 100.0;
        double d2 = this.scales[this.dim2].getRelativeScaled(numberVector.doubleValue(this.dim2)) * -100.0;
        return new double[]{d, d2};
    }

    @Override
    public double[] fastProjectRelativeScaledToRenderSpace(double[] dArray) {
        double d = dArray[this.dim1] * 100.0;
        double d2 = dArray[this.dim2] * -100.0;
        return new double[]{d, d2};
    }

    @Override
    public long[] getVisibleDimensions2D() {
        long[] lArray = new long[this.scales.length];
        BitsUtil.setI(lArray, this.dim1);
        BitsUtil.setI(lArray, this.dim2);
        return lArray;
    }

    @Override
    public CanvasSize estimateViewport() {
        return new CanvasSize(-50.0, 50.0, -50.0, 50.0);
    }

    @Override
    protected double[] rearrange(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = dArray[this.dim1];
        dArray2[1] = dArray[this.dim2];
        int n = Math.min(this.dim1, this.dim2);
        int n2 = Math.max(this.dim1, this.dim2);
        if (n > 0) {
            System.arraycopy(dArray, 0, dArray2, 2, n);
        }
        if (n2 - n > 1) {
            System.arraycopy(dArray, n + 1, dArray2, n + 2, n2 - (n + 1));
        }
        if (n2 + 1 < dArray.length) {
            System.arraycopy(dArray, n2 + 1, dArray2, n2 + 1, dArray.length - (n2 + 1));
        }
        return dArray2;
    }

    @Override
    protected double[] dearrange(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        dArray2[this.dim1] = dArray[0];
        dArray2[this.dim2] = dArray[1];
        int n = Math.min(this.dim1, this.dim2);
        int n2 = Math.max(this.dim1, this.dim2);
        if (n > 0) {
            System.arraycopy(dArray, 2, dArray2, 0, n);
        }
        if (n2 - n > 1) {
            System.arraycopy(dArray, n + 2, dArray2, n + 1, n2 - (n + 1));
        }
        if (n2 + 1 < dArray.length) {
            System.arraycopy(dArray, n2 + 1, dArray2, n2 + 1, dArray.length - (n2 + 1));
        }
        return dArray2;
    }

    @Override
    public String getMenuName() {
        return "Scatterplot";
    }
}

