/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.jgap.Configuration;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelectorExt;
import org.jgap.Population;
import org.jgap.RandomGenerator;

public class TournamentSelector
extends NaturalSelectorExt {
    private static final String CVS_REVISION = "$Revision: 1.24 $";
    private TournamentSelectorConfigurable m_config = new TournamentSelectorConfigurable();
    private List m_chromosomes;
    private FitnessValueComparator m_fitnessValueComparator;

    public TournamentSelector() throws InvalidConfigurationException {
        super(Genotype.getStaticConfiguration());
        this.init();
    }

    private void init() {
        this.m_chromosomes = new Vector();
        this.m_fitnessValueComparator = new FitnessValueComparator();
    }

    public TournamentSelector(Configuration a_config, int a_tournament_size, double a_probability) throws InvalidConfigurationException {
        super(a_config);
        this.init();
        if (a_tournament_size < 1) {
            throw new IllegalArgumentException("Tournament size must be at least 1!");
        }
        if (a_probability <= 0.0 || a_probability > 1.0) {
            throw new IllegalArgumentException("Probability must be greater 0.0 and less or equal than 1.0!");
        }
        this.m_config.m_tournament_size = a_tournament_size;
        this.m_config.m_probability = a_probability;
    }

    public void setTournamentSize(int a_tournament_size) {
        if (a_tournament_size < 1) {
            throw new IllegalArgumentException("Tournament size must be at least 1!");
        }
        this.m_config.m_tournament_size = a_tournament_size;
    }

    public int getTournamentSize() {
        return this.m_config.m_tournament_size;
    }

    public double getProbability() {
        return this.m_config.m_probability;
    }

    public void setProbability(double a_probability) {
        if (a_probability <= 0.0 || a_probability > 1.0) {
            throw new IllegalArgumentException("Probability must be greater 0.0 and less or equal than 1.0!");
        }
        this.m_config.m_probability = a_probability;
    }

    public void selectChromosomes(int a_howManyToSelect, Population a_to_pop) {
        Vector tournament = new Vector();
        RandomGenerator rn = this.getConfiguration().getRandomGenerator();
        int size = this.m_chromosomes.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < a_howManyToSelect; ++i) {
            tournament.clear();
            for (int j = 0; j < this.m_config.m_tournament_size; ++j) {
                int k = rn.nextInt(size);
                tournament.add(this.m_chromosomes.get(k));
            }
            Collections.sort(tournament, this.m_fitnessValueComparator);
            double prob = rn.nextDouble();
            int index = 0;
            if (this.m_config.m_tournament_size > 1) {
                for (double probAccumulated = this.m_config.m_probability; !(prob <= probAccumulated); probAccumulated += probAccumulated * (1.0 - this.m_config.m_probability)) {
                    if (++index < this.m_config.m_tournament_size - 1) continue;
                }
            }
            a_to_pop.addChromosome((IChromosome)tournament.get(index));
        }
    }

    public boolean returnsUniqueChromosomes() {
        return false;
    }

    public void empty() {
        this.m_chromosomes.clear();
    }

    protected void add(IChromosome a_chromosomeToAdd) {
        this.m_chromosomes.add(a_chromosomeToAdd);
    }

    class TournamentSelectorConfigurable
    implements Serializable {
        public double m_probability;
        public int m_tournament_size;

        TournamentSelectorConfigurable() {
        }
    }

    private class FitnessValueComparator
    implements Comparator {
        public int compare(Object a_first, Object a_second) {
            IChromosome chrom1 = (IChromosome)a_first;
            IChromosome chrom2 = (IChromosome)a_second;
            if (TournamentSelector.this.getConfiguration().getFitnessEvaluator().isFitter(chrom2.getFitnessValue(), chrom1.getFitnessValue())) {
                return 1;
            }
            if (TournamentSelector.this.getConfiguration().getFitnessEvaluator().isFitter(chrom1.getFitnessValue(), chrom2.getFitnessValue())) {
                return -1;
            }
            return 0;
        }
    }
}

