/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.perf;

import org.jgap.FitnessFunction;
import org.jgap.IChromosome;

public class TestOverallPerformanceFitnessFunc
extends FitnessFunction {
    private static final String CVS_REVISION = "$Revision: 1.4 $";
    private final int m_targetAmount;

    public TestOverallPerformanceFitnessFunc(int a_targetAmount) {
        if (a_targetAmount < 1 || a_targetAmount > 999) {
            throw new IllegalArgumentException("Change amount must be between 1 and 999 cents.");
        }
        this.m_targetAmount = a_targetAmount;
    }

    public double evaluate(IChromosome a_subject) {
        int changeAmount = TestOverallPerformanceFitnessFunc.amountOfChange(a_subject);
        int totalCoins = TestOverallPerformanceFitnessFunc.getTotalNumberOfCoins(a_subject);
        int changeDifference = Math.abs(this.m_targetAmount - changeAmount);
        int fitness = 99 - changeDifference;
        if (changeAmount == this.m_targetAmount) {
            fitness += 100 - 10 * totalCoins;
        }
        return Math.max(1, fitness);
    }

    public static int amountOfChange(IChromosome a_potentialSolution) {
        int numQuarters = TestOverallPerformanceFitnessFunc.getNumberOfCoinsAtGene(a_potentialSolution, 0);
        int numDimes = TestOverallPerformanceFitnessFunc.getNumberOfCoinsAtGene(a_potentialSolution, 1);
        int numNickels = TestOverallPerformanceFitnessFunc.getNumberOfCoinsAtGene(a_potentialSolution, 2);
        int numPennies = TestOverallPerformanceFitnessFunc.getNumberOfCoinsAtGene(a_potentialSolution, 3);
        int A = TestOverallPerformanceFitnessFunc.getNumberOfCoinsAtGene(a_potentialSolution, 4);
        int B = TestOverallPerformanceFitnessFunc.getNumberOfCoinsAtGene(a_potentialSolution, 5);
        int C = TestOverallPerformanceFitnessFunc.getNumberOfCoinsAtGene(a_potentialSolution, 6);
        int D = TestOverallPerformanceFitnessFunc.getNumberOfCoinsAtGene(a_potentialSolution, 7);
        int E = TestOverallPerformanceFitnessFunc.getNumberOfCoinsAtGene(a_potentialSolution, 8);
        int F = TestOverallPerformanceFitnessFunc.getNumberOfCoinsAtGene(a_potentialSolution, 9);
        return numQuarters * 25 + numDimes * 10 + numNickels * 5 + numPennies + A * 29 + B * 31 + C * 37 + D * 41 + E * 43 + F * 47;
    }

    public static int getNumberOfCoinsAtGene(IChromosome a_potentialSolution, int a_position) {
        Integer numCoins = (Integer)a_potentialSolution.getGene(a_position).getAllele();
        return numCoins;
    }

    public static int getTotalNumberOfCoins(IChromosome a_potentialsolution) {
        int totalCoins = 0;
        int numberOfGenes = a_potentialsolution.size();
        for (int i = 0; i < numberOfGenes; ++i) {
            totalCoins += TestOverallPerformanceFitnessFunc.getNumberOfCoinsAtGene(a_potentialsolution, i);
        }
        return totalCoins;
    }
}

