/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction;

import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.DendrogramModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import java.util.ArrayList;

@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.ExtractFlatClusteringFromHierarchy"})
public class ExtractFlatClusteringFromHierarchy
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    private static final Logging LOG = Logging.getLogger(ExtractFlatClusteringFromHierarchy.class);
    private final int minclusters;
    private final double threshold;
    private final boolean hierarchical;
    private final boolean nosingletons;
    private final HierarchicalClusteringAlgorithm algorithm;

    public ExtractFlatClusteringFromHierarchy(HierarchicalClusteringAlgorithm hierarchicalClusteringAlgorithm, int n, boolean bl, boolean bl2) {
        this.algorithm = hierarchicalClusteringAlgorithm;
        this.threshold = Double.NaN;
        this.minclusters = n;
        this.hierarchical = bl;
        this.nosingletons = bl2;
    }

    public ExtractFlatClusteringFromHierarchy(HierarchicalClusteringAlgorithm hierarchicalClusteringAlgorithm, double d, boolean bl, boolean bl2) {
        this.algorithm = hierarchicalClusteringAlgorithm;
        this.threshold = d;
        this.minclusters = -1;
        this.hierarchical = bl;
        this.nosingletons = bl2;
    }

    @Override
    public Clustering<DendrogramModel> run(Database database) {
        PointerHierarchyRepresentationResult pointerHierarchyRepresentationResult = this.algorithm.run(database);
        DBIDs dBIDs = pointerHierarchyRepresentationResult.getDBIDs();
        DBIDDataStore dBIDDataStore = pointerHierarchyRepresentationResult.getParentStore();
        DoubleDataStore doubleDataStore = pointerHierarchyRepresentationResult.getParentDistanceStore();
        Clustering<DendrogramModel> clustering = this.extractClusters(dBIDs, dBIDDataStore, doubleDataStore);
        clustering.addChildResult(pointerHierarchyRepresentationResult);
        return clustering;
    }

    public Clustering<DendrogramModel> extractClusters(DBIDs dBIDs, DBIDDataStore dBIDDataStore, DoubleDataStore doubleDataStore) {
        Clustering<DendrogramModel> clustering;
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Extracting clusters", dBIDs.size(), LOG) : null;
        ArrayDBIDs arrayDBIDs = PointerHierarchyRepresentationResult.topologicalSort(dBIDs, dBIDDataStore, doubleDataStore);
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        int n = this.findSplit(arrayDBIDs, dBIDArrayIter, doubleDataStore);
        int n2 = dBIDs.size() - n;
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(dBIDs, 1, -1);
        ArrayList<ArrayModifiableDBIDs> arrayList = new ArrayList<ArrayModifiableDBIDs>(n2 + 10);
        DoubleArray doubleArray = new DoubleArray(n2 + 10);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(n2 + 10);
        DBIDVar dBIDVar = DBIDUtil.newVar();
        dBIDArrayIter.seek(n - 1);
        while (dBIDArrayIter.valid()) {
            double d = doubleDataStore.doubleValue(dBIDArrayIter);
            dBIDDataStore.assignVar(dBIDArrayIter, dBIDVar);
            int n3 = writableIntegerDataStore.intValue(dBIDVar);
            if (n3 >= 0) {
                ((ModifiableDBIDs)arrayList.get(n3)).add(dBIDArrayIter);
                writableIntegerDataStore.putInt(dBIDArrayIter, n3);
                if (doubleArray.get(n3) < d) {
                    doubleArray.set(n3, d);
                }
            } else {
                n3 = arrayList.size();
                ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray();
                arrayModifiableDBIDs2.add(dBIDVar);
                writableIntegerDataStore.putInt(dBIDVar, n3);
                arrayModifiableDBIDs2.add(dBIDArrayIter);
                writableIntegerDataStore.putInt(dBIDArrayIter, n3);
                arrayList.add(arrayModifiableDBIDs2);
                arrayModifiableDBIDs.add(dBIDVar);
                doubleArray.add(d);
            }
            LOG.incrementProcessed(finiteProgress);
            dBIDArrayIter.retract();
        }
        if (this.hierarchical) {
            clustering = new Clustering<DendrogramModel>("Hierarchical Clustering", "hierarchical-clustering");
            Cluster<DendrogramModel> cluster = null;
            ArrayList<Cluster<DendrogramModel>> arrayList2 = new ArrayList<Cluster<DendrogramModel>>(n2);
            int n4 = 0;
            Object object = arrayModifiableDBIDs.iter();
            while (object.valid()) {
                double d = doubleArray.get(n4);
                arrayList2.add(this.makeCluster((DBIDRef)object, d, (DBIDs)arrayList.get(n4)));
                object.advance();
                ++n4;
            }
            doubleArray = null;
            arrayList = null;
            dBIDArrayIter.seek(n);
            while (dBIDArrayIter.valid()) {
                n4 = writableIntegerDataStore.intValue(dBIDArrayIter);
                object = n4 >= 0 ? (Cluster)arrayList2.get(n4) : (this.nosingletons && dBIDs.size() > 1 ? null : this.makeCluster(dBIDArrayIter, Double.NaN, DBIDUtil.deref(dBIDArrayIter)));
                dBIDDataStore.assignVar(dBIDArrayIter, dBIDVar);
                if (DBIDUtil.equal(dBIDArrayIter, dBIDVar)) {
                    assert (cluster == null);
                    cluster = object;
                    LOG.incrementProcessed(finiteProgress);
                } else {
                    ArrayModifiableDBIDs arrayModifiableDBIDs3;
                    Cluster<DendrogramModel> cluster2;
                    int n5 = writableIntegerDataStore.intValue(dBIDVar);
                    double d = doubleDataStore.doubleValue(dBIDArrayIter);
                    if (n5 >= 0) {
                        cluster2 = (Cluster<DendrogramModel>)arrayList2.get(n5);
                        if (((DendrogramModel)cluster2.getModel()).getDistance() == d) {
                            if (object == null) {
                                ((ModifiableDBIDs)cluster2.getIDs()).add(dBIDArrayIter);
                            } else {
                                clustering.addChildCluster(cluster2, (Cluster<DendrogramModel>)object);
                            }
                        } else {
                            arrayModifiableDBIDs3 = DBIDUtil.newArray(object == null ? 1 : 0);
                            if (object == null) {
                                arrayModifiableDBIDs3.add(dBIDArrayIter);
                            }
                            Cluster<DendrogramModel> cluster3 = this.makeCluster(dBIDVar, d, arrayModifiableDBIDs3);
                            if (object != null) {
                                clustering.addChildCluster(cluster3, (Cluster<DendrogramModel>)object);
                            }
                            clustering.addChildCluster(cluster3, cluster2);
                            arrayList2.set(n5, cluster3);
                        }
                    } else {
                        if (this.nosingletons) {
                            arrayModifiableDBIDs3 = DBIDUtil.newArray(object == null ? 2 : 1);
                            arrayModifiableDBIDs3.add(dBIDVar);
                            if (object == null) {
                                arrayModifiableDBIDs3.add(dBIDArrayIter);
                            }
                            cluster2 = this.makeCluster(dBIDVar, d, arrayModifiableDBIDs3);
                        } else {
                            cluster2 = this.makeCluster(dBIDVar, d, DBIDUtil.EMPTYDBIDS);
                            clustering.addChildCluster(cluster2, this.makeCluster(dBIDVar, Double.NaN, DBIDUtil.deref(dBIDVar)));
                        }
                        if (object != null) {
                            clustering.addChildCluster(cluster2, (Cluster<DendrogramModel>)object);
                        }
                        n5 = arrayList2.size();
                        arrayList2.add(cluster2);
                        writableIntegerDataStore.putInt(dBIDVar, n5);
                    }
                    LOG.incrementProcessed(finiteProgress);
                }
                dBIDArrayIter.advance();
            }
            assert (cluster != null);
            clustering.addToplevelCluster(cluster);
        } else {
            clustering = new Clustering("Flattened Hierarchical Clustering", "flattened-hierarchical-clustering");
            int n6 = 0;
            DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
            while (dBIDArrayMIter.valid()) {
                double d = doubleArray.get(n6);
                clustering.addToplevelCluster(this.makeCluster(dBIDArrayMIter, d, (DBIDs)arrayList.get(n6)));
                dBIDArrayMIter.advance();
                ++n6;
            }
            doubleArray = null;
            if (this.nosingletons) {
                dBIDArrayIter.seek(n);
                while (dBIDArrayIter.valid()) {
                    n6 = writableIntegerDataStore.intValue(dBIDVar);
                    if (n6 >= 0) {
                        ((ModifiableDBIDs)arrayList.get(n6)).add(dBIDArrayIter);
                        writableIntegerDataStore.put((DBIDRef)dBIDArrayIter, n6);
                    }
                    dBIDArrayIter.advance();
                }
            }
            dBIDArrayIter.seek(n);
            while (dBIDArrayIter.valid()) {
                n6 = writableIntegerDataStore.intValue(dBIDArrayIter);
                if (n6 < 0) {
                    clustering.addToplevelCluster(this.makeCluster(dBIDArrayIter, Double.NaN, DBIDUtil.deref(dBIDArrayIter)));
                }
                LOG.incrementProcessed(finiteProgress);
                dBIDArrayIter.advance();
            }
            arrayList = null;
        }
        LOG.ensureCompleted(finiteProgress);
        return clustering;
    }

    private int findSplit(ArrayDBIDs arrayDBIDs, DBIDArrayIter dBIDArrayIter, DoubleDataStore doubleDataStore) {
        int n;
        if (this.minclusters > 0) {
            n = arrayDBIDs.size() > this.minclusters ? arrayDBIDs.size() - this.minclusters : 0;
            dBIDArrayIter.seek(n);
            double d = doubleDataStore.doubleValue(dBIDArrayIter);
            dBIDArrayIter.retract();
            while (dBIDArrayIter.valid() && d <= doubleDataStore.doubleValue(dBIDArrayIter)) {
                --n;
                dBIDArrayIter.retract();
            }
        } else if (!Double.isNaN(this.threshold)) {
            n = arrayDBIDs.size();
            dBIDArrayIter.seek(n - 1);
            while (dBIDArrayIter.valid() && this.threshold <= doubleDataStore.doubleValue(dBIDArrayIter)) {
                --n;
                dBIDArrayIter.retract();
            }
        } else {
            n = 0;
        }
        return n;
    }

    private Cluster<DendrogramModel> makeCluster(DBIDRef dBIDRef, double d, DBIDs dBIDs) {
        String string = dBIDs.size() == 0 ? "mrg_" + DBIDUtil.toString(dBIDRef) + "_" + d : (!Double.isNaN(d) && Double.isInfinite(d) || dBIDs.size() == 1 && dBIDs.contains(dBIDRef) ? "obj_" + DBIDUtil.toString(dBIDRef) : (!Double.isNaN(d) ? "clu_" + DBIDUtil.toString(dBIDRef) + "_" + d : "clu_" + DBIDUtil.toString(dBIDRef)));
        Cluster<DendrogramModel> cluster = new Cluster<DendrogramModel>(string, dBIDs, new DendrogramModel(d));
        return cluster;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MODE_ID = new OptionID("hierarchical.threshold-mode", "The thresholding mode to use for extracting clusters: by desired number of clusters, or by distance threshold.");
        public static final OptionID MINCLUSTERS_ID = new OptionID("hierarchical.minclusters", "The minimum number of clusters to extract (there may be more clusters when tied).");
        public static final OptionID THRESHOLD_ID = new OptionID("hierarchical.threshold", "The threshold level for which to extract the clusters.");
        public static final OptionID HIERARCHICAL_ID = new OptionID("hierarchical.hierarchy", "Generate a truncated hierarchical clustering result (or strict partitions).");
        public static final OptionID NO_SINGLETONS_ID = new OptionID("hierarchical.mergesingletons", "Merge singleton clusters into parent. This produces a more complex hierarchy, but that is easier to understand.");
        ThresholdMode thresholdmode = null;
        int minclusters = -1;
        double threshold = Double.NaN;
        boolean hierarchical = false;
        boolean nosingletons = false;
        HierarchicalClusteringAlgorithm algorithm;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            AbstractParameter abstractParameter;
            EnumParameter<ThresholdMode> enumParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(AlgorithmStep.Parameterizer.ALGORITHM_ID, HierarchicalClusteringAlgorithm.class);
            if (parameterization.grab(objectParameter)) {
                this.algorithm = (HierarchicalClusteringAlgorithm)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<ThresholdMode>(MODE_ID, ThresholdMode.class, ThresholdMode.BY_MINCLUSTERS))) {
                this.thresholdmode = (ThresholdMode)((Object)enumParameter.getValue());
            }
            if ((this.thresholdmode == null || ThresholdMode.BY_MINCLUSTERS.equals((Object)this.thresholdmode)) && parameterization.grab(abstractParameter = (IntParameter)new IntParameter(MINCLUSTERS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minclusters = ((IntParameter)abstractParameter).intValue();
            }
            if ((this.thresholdmode == null || ThresholdMode.BY_THRESHOLD.equals((Object)this.thresholdmode)) && parameterization.grab(abstractParameter = new DoubleParameter(THRESHOLD_ID))) {
                this.threshold = (Double)abstractParameter.getValue();
            }
            if (this.thresholdmode == null || !ThresholdMode.NO_THRESHOLD.equals((Object)this.thresholdmode)) {
                abstractParameter = new Flag(HIERARCHICAL_ID);
                if (parameterization.grab(abstractParameter)) {
                    this.hierarchical = ((Flag)abstractParameter).isTrue();
                }
            } else {
                this.minclusters = -1;
                this.hierarchical = true;
            }
            abstractParameter = new Flag(NO_SINGLETONS_ID);
            if (parameterization.grab(abstractParameter)) {
                this.nosingletons = ((Flag)abstractParameter).isTrue();
            }
        }

        @Override
        protected ExtractFlatClusteringFromHierarchy makeInstance() {
            switch (this.thresholdmode) {
                case NO_THRESHOLD: 
                case BY_MINCLUSTERS: {
                    return new ExtractFlatClusteringFromHierarchy(this.algorithm, this.minclusters, this.hierarchical, this.nosingletons);
                }
                case BY_THRESHOLD: {
                    return new ExtractFlatClusteringFromHierarchy(this.algorithm, this.threshold, this.hierarchical, this.nosingletons);
                }
            }
            throw new AbortException("Unknown extraction mode.");
        }
    }

    public static enum ThresholdMode {
        BY_MINCLUSTERS,
        BY_THRESHOLD,
        NO_THRESHOLD;

    }
}

