/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.weighted;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.weighted.WeightedNeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Collection;

public class UnweightedNeighborhoodAdapter
implements WeightedNeighborSetPredicate {
    NeighborSetPredicate inner;

    public UnweightedNeighborhoodAdapter(NeighborSetPredicate neighborSetPredicate) {
        this.inner = neighborSetPredicate;
    }

    @Override
    public Collection<DoubleDBIDPair> getWeightedNeighbors(DBIDRef dBIDRef) {
        DBIDs dBIDs = this.inner.getNeighborDBIDs(dBIDRef);
        ArrayList<DoubleDBIDPair> arrayList = new ArrayList<DoubleDBIDPair>(dBIDs.size());
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            arrayList.add(DBIDUtil.newPair(1.0, (DBIDRef)dBIDIter));
            dBIDIter.advance();
        }
        return arrayList;
    }

    public static class Factory<O>
    implements WeightedNeighborSetPredicate.Factory<O> {
        NeighborSetPredicate.Factory<O> inner;

        public Factory(NeighborSetPredicate.Factory<O> factory) {
            this.inner = factory;
        }

        @Override
        public UnweightedNeighborhoodAdapter instantiate(Database database, Relation<? extends O> relation) {
            return new UnweightedNeighborhoodAdapter(this.inner.instantiate(database, relation));
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.inner.getInputTypeRestriction();
        }

        public static class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID INNER_ID = new OptionID("neighborhood.inner", "Parameter for the non-weighted neighborhood to use.");
            NeighborSetPredicate.Factory<O> inner;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                super.makeOptions(parameterization);
                ObjectParameter objectParameter = new ObjectParameter(INNER_ID, NeighborSetPredicate.Factory.class);
                if (parameterization.grab(objectParameter)) {
                    this.inner = (NeighborSetPredicate.Factory)objectParameter.instantiateClass(parameterization);
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.inner);
            }
        }
    }
}

