/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.clustering.BCubed;
import de.lmu.ifi.dbs.elki.evaluation.clustering.EditDistance;
import de.lmu.ifi.dbs.elki.evaluation.clustering.Entropy;
import de.lmu.ifi.dbs.elki.evaluation.clustering.PairCounting;
import de.lmu.ifi.dbs.elki.evaluation.clustering.SetMatchingPurity;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import java.util.Iterator;
import java.util.List;

public class ClusterContingencyTable {
    protected boolean breakNoiseClusters = false;
    protected boolean selfPairing = true;
    protected int size1 = -1;
    protected int size2 = -1;
    protected int[][] contingency = null;
    protected long[] noise1 = null;
    protected long[] noise2 = null;
    protected PairCounting paircount = null;
    protected Entropy entropy = null;
    protected SetMatchingPurity smp = null;
    protected EditDistance edit = null;
    protected BCubed bcubed = null;

    public ClusterContingencyTable(boolean bl, boolean bl2) {
        this.selfPairing = bl;
        this.breakNoiseClusters = bl2;
    }

    public void process(Clustering<?> clustering, Clustering<?> clustering2) {
        Cluster<?> cluster;
        List<Cluster<?>> list = clustering.getAllClusters();
        List<Cluster<?>> list2 = clustering2.getAllClusters();
        this.size1 = list.size();
        this.size2 = list2.size();
        this.contingency = new int[this.size1 + 2][this.size2 + 2];
        this.noise1 = BitsUtil.zero(this.size1);
        this.noise2 = BitsUtil.zero(this.size2);
        Iterator<Cluster<?>> iterator = list2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            cluster = iterator.next();
            if (cluster.isNoise()) {
                BitsUtil.setI(this.noise2, n);
            }
            this.contingency[this.size1 + 1][n] = cluster.size();
            int[] nArray = this.contingency[this.size1 + 1];
            int n2 = this.size2;
            nArray[n2] = nArray[n2] + cluster.size();
            ++n;
        }
        iterator = list.iterator();
        n = 0;
        while (iterator.hasNext()) {
            cluster = iterator.next();
            if (cluster.isNoise()) {
                BitsUtil.setI(this.noise1, n);
            }
            SetDBIDs setDBIDs = DBIDUtil.ensureSet(cluster.getIDs());
            this.contingency[n][this.size2 + 1] = cluster.size();
            int[] nArray = this.contingency[this.size1];
            int n3 = this.size2 + 1;
            nArray[n3] = nArray[n3] + cluster.size();
            Iterator<Cluster<?>> iterator2 = list2.iterator();
            int n4 = 0;
            while (iterator2.hasNext()) {
                int n5;
                Cluster<?> cluster2 = iterator2.next();
                this.contingency[n][n4] = n5 = DBIDUtil.intersectionSize(setDBIDs, cluster2.getIDs());
                int[] nArray2 = this.contingency[n];
                int n6 = this.size2;
                nArray2[n6] = nArray2[n6] + n5;
                int[] nArray3 = this.contingency[this.size1];
                int n7 = n4++;
                nArray3[n7] = nArray3[n7] + n5;
                int[] nArray4 = this.contingency[this.size1];
                int n8 = this.size2;
                nArray4[n8] = nArray4[n8] + n5;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.contingency != null) {
            for (int i = 0; i < this.size1 + 2; ++i) {
                if (i >= this.size1) {
                    stringBuilder.append("------\n");
                }
                for (int j = 0; j < this.size2 + 2; ++j) {
                    if (j >= this.size2) {
                        stringBuilder.append("| ");
                    }
                    stringBuilder.append(this.contingency[i][j]).append(' ');
                }
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public PairCounting getPaircount() {
        if (this.paircount == null) {
            this.paircount = new PairCounting(this);
        }
        return this.paircount;
    }

    public Entropy getEntropy() {
        if (this.entropy == null) {
            this.entropy = new Entropy(this);
        }
        return this.entropy;
    }

    public EditDistance getEdit() {
        if (this.edit == null) {
            this.edit = new EditDistance(this);
        }
        return this.edit;
    }

    public BCubed getBCubed() {
        if (this.bcubed == null) {
            this.bcubed = new BCubed(this);
        }
        return this.bcubed;
    }

    public SetMatchingPurity getSetMatching() {
        if (this.smp == null) {
            this.smp = new SetMatchingPurity(this);
        }
        return this.smp;
    }

    public MeanVariance averageSymmetricGini() {
        double d;
        int n;
        double d2;
        double d3;
        int n2;
        MeanVariance meanVariance = new MeanVariance();
        for (n2 = 0; n2 < this.size1; ++n2) {
            d3 = 0.0;
            if (this.contingency[n2][this.size2] <= 0) continue;
            d2 = this.contingency[n2][this.size2];
            for (n = 0; n < this.size2; ++n) {
                d = (double)this.contingency[n2][n] / d2;
                d3 += d * d;
            }
            meanVariance.put(d3, d2);
        }
        for (n2 = 0; n2 < this.size2; ++n2) {
            d3 = 0.0;
            if (this.contingency[this.size1][n2] <= 0) continue;
            d2 = this.contingency[this.size1][n2];
            for (n = 0; n < this.size1; ++n) {
                d = (double)this.contingency[n][n2] / d2;
                d3 += d * d;
            }
            meanVariance.put(d3, d2);
        }
        return meanVariance;
    }

    public static final class Util {
        public static double fMeasure(double d, double d2, double d3) {
            double d4 = d3 * d3;
            return (1.0 + d4) * d * d2 / (d4 * d + d2);
        }

        public static double f1Measure(double d, double d2) {
            return 2.0 * d * d2 / (d + d2);
        }
    }
}

