/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.logging.ErrorFormatter;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.logging.MessageFormatter;
import de.lmu.ifi.dbs.elki.logging.progress.ProgressLogRecord;
import java.awt.Color;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class LogPane
extends JTextPane {
    private static final long serialVersionUID = 1L;
    protected Style baseStyle;
    protected Style msgStyle;
    protected Style dbgStyle;
    protected Style errStyle;
    private Formatter msgformat = new MessageFormatter();
    private Formatter debugformat = new ErrorFormatter();
    private Formatter errformat = new ErrorFormatter();
    private int lastNewlinePos = 0;

    public LogPane() {
        this.baseStyle = this.getStyledDocument().addStyle(null, null);
        this.msgStyle = this.getStyledDocument().addStyle("msg", this.baseStyle);
        this.errStyle = this.getStyledDocument().addStyle("err", this.baseStyle);
        this.errStyle.addAttribute(StyleConstants.Foreground, Color.RED);
        this.dbgStyle = this.getStyledDocument().addStyle("err", this.baseStyle);
        this.dbgStyle.addAttribute(StyleConstants.Foreground, Color.BLUE);
    }

    public void publish(String string, Level level) {
        try {
            this.publish(new LogRecord(level, string));
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Error writing a log-like message.", badLocationException);
        }
    }

    protected synchronized void publish(LogRecord logRecord) throws BadLocationException {
        String string;
        Style style;
        Formatter formatter;
        if (logRecord.getLevel().intValue() >= Level.WARNING.intValue()) {
            formatter = this.errformat;
            style = this.errStyle;
        } else if (logRecord.getLevel().intValue() <= Level.FINE.intValue()) {
            formatter = this.debugformat;
            style = this.dbgStyle;
        } else {
            formatter = this.msgformat;
            style = this.msgStyle;
        }
        String string2 = formatter.format(logRecord);
        if (logRecord instanceof ProgressLogRecord) {
            if (this.lastNewlinePos < this.getStyledDocument().getLength()) {
                this.getStyledDocument().remove(this.lastNewlinePos, this.getStyledDocument().getLength() - this.lastNewlinePos);
            }
        } else if (this.lastNewlinePos < this.getStyledDocument().getLength()) {
            this.getStyledDocument().insertString(this.getStyledDocument().getLength(), "\n", style);
            this.lastNewlinePos = this.getStyledDocument().getLength();
        }
        int n = this.tailingNonNewline(string2, 0, string2.length());
        int n2 = string2.length() - n;
        if (n2 > 0) {
            string = string2.substring(0, n2);
            this.getStyledDocument().insertString(this.getStyledDocument().getLength(), string, style);
        }
        this.lastNewlinePos = this.getStyledDocument().getLength();
        if (n > 0) {
            string = string2.substring(string2.length() - n);
            this.getStyledDocument().insertString(this.lastNewlinePos, string, style);
        }
    }

    private int tailingNonNewline(String string, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n + (n2 - 1) - i;
            if (string.charAt(n3) != '\n') continue;
            return i;
        }
        return n2;
    }

    public void clear() {
        this.setText("");
        this.lastNewlinePos = 0;
    }

    public void becomeDefaultLogger() {
        LoggingConfiguration.replaceDefaultHandler(new LogPaneHandler());
    }

    private class LogPaneHandler
    extends Handler {
        protected LogPaneHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord logRecord) {
            try {
                LogPane.this.publish(logRecord);
            }
            catch (Exception exception) {
                this.reportError("Error printing output log message.", exception, 0);
            }
        }
    }
}

