/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Reference(authors="E. Schubert, A. Zimek, H.-P. Kriegel", title="Fast and Scalable Outlier Detection with Approximate Nearest Neighbor Ensembles", booktitle="Proc. 20th International Conference on Database Systems for Advanced Applications (DASFAA)", url="http://dx.doi.org/10.1007/978-3-319-18123-3_2")
public class NaiveProjectedKNNPreprocessor<O extends NumberVector>
extends AbstractIndex<O>
implements KNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(NaiveProjectedKNNPreprocessor.class);
    final double window;
    final int projections;
    WritableDataStore<int[]> positions = null;
    Mean mean = new Mean();
    RandomProjectionFamily proj;
    Random random;
    List<ModifiableDoubleDBIDList> projected;

    public NaiveProjectedKNNPreprocessor(Relation<O> relation, double d, int n, RandomProjectionFamily randomProjectionFamily, Random random) {
        super(relation);
        this.window = d;
        this.projections = n;
        this.proj = randomProjectionFamily;
        this.random = random;
    }

    @Override
    public void initialize() {
        if (this.positions != null) {
            throw new UnsupportedOperationException("Preprocessor already ran.");
        }
        if (this.relation.size() > 0) {
            this.preprocess();
        }
    }

    protected void preprocess() {
        int n;
        int n2;
        Object object;
        DBIDIter dBIDIter;
        Object object2;
        long l = System.nanoTime();
        int n3 = this.relation.size();
        int n4 = RelationUtil.dimensionality(this.relation);
        int n5 = this.projections > 0 ? this.projections : n4;
        this.projected = new ArrayList<ModifiableDoubleDBIDList>(n5);
        for (int i = 0; i < n5; ++i) {
            this.projected.add(DBIDUtil.newDistanceDBIDList(n3));
        }
        if (this.proj == null) {
            object2 = NaiveProjectedKNNPreprocessor.range(0, n4);
            if (n5 < n4) {
                NaiveProjectedKNNPreprocessor.randomPermutation((int[])object2, this.random);
            }
            dBIDIter = this.relation.iterDBIDs();
            while (dBIDIter.valid()) {
                object = (NumberVector)this.relation.get(dBIDIter);
                for (n2 = 0; n2 < n5; ++n2) {
                    this.projected.get(n2).add(object.doubleValue((int)object2[n2]), dBIDIter);
                }
                dBIDIter.advance();
            }
        } else {
            object2 = this.proj.generateProjection(n4, n5);
            dBIDIter = this.relation.iterDBIDs();
            while (dBIDIter.valid()) {
                object = object2.project((NumberVector)this.relation.get(dBIDIter));
                for (n2 = 0; n2 < n5; ++n2) {
                    this.projected.get(n2).add((double)object[n2], dBIDIter);
                }
                dBIDIter.advance();
            }
        }
        for (n = 0; n < n5; ++n) {
            this.projected.get(n).sort();
        }
        this.positions = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, int[].class);
        for (n = 0; n < n5; ++n) {
            dBIDIter = this.projected.get(n).iter();
            int n6 = 0;
            while (dBIDIter.valid()) {
                int[] nArray;
                if (n == 0) {
                    nArray = new int[n5];
                    this.positions.put(dBIDIter, nArray);
                } else {
                    nArray = (int[])this.positions.get(dBIDIter);
                }
                nArray[n] = n6++;
                dBIDIter.advance();
            }
        }
        long l2 = System.nanoTime();
        if (LOG.isVerbose()) {
            LOG.verbose("SFC preprocessor took " + (double)(l2 - l) / 1000000.0 + " milliseconds.");
        }
    }

    public static int[] range(int n, int n2) {
        int[] nArray = new int[n2 - n];
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            nArray[n3] = n4++;
            ++n3;
        }
        return nArray;
    }

    public static int[] randomPermutation(int[] nArray, Random random) {
        for (int i = nArray.length - 1; i > 0; --i) {
            int n = random.nextInt(i + 1);
            int n2 = nArray[n];
            nArray[n] = nArray[i];
            nArray[i] = n2;
        }
        return nArray;
    }

    @Override
    public String getLongName() {
        return "Space Filling Curve KNN preprocessor";
    }

    @Override
    public String getShortName() {
        return "spacefilling-knn";
    }

    @Override
    public void logStatistics() {
        LOG.statistics(new DoubleStatistic(this.getClass().getCanonicalName() + ".distance-computations-per-k", this.mean.getMean()));
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        for (Object object : objectArray) {
            if (!"exact".equals(object)) continue;
            return null;
        }
        return new NaiveProjectedKNNQuery(distanceQuery);
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V, NaiveProjectedKNNPreprocessor<V>> {
        double window;
        int projections;
        RandomProjectionFamily proj;
        RandomFactory random;

        public Factory(double d, int n, RandomProjectionFamily randomProjectionFamily, RandomFactory randomFactory) {
            this.window = d;
            this.projections = n;
            this.proj = randomProjectionFamily;
            this.random = randomFactory;
        }

        @Override
        public NaiveProjectedKNNPreprocessor<V> instantiate(Relation<V> relation) {
            return new NaiveProjectedKNNPreprocessor<V>(relation, this.window, this.projections, this.proj, this.random.getRandom());
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            public static final OptionID WINDOW_ID = new OptionID("projections.windowmult", "Window size multiplicator.");
            public static final OptionID PROJECTIONS_ID = new OptionID("projections.projections", "Number of projections to use.");
            public static final OptionID PROJECTION_ID = new OptionID("projections.family", "Random projection family to use. The default is to use the original axes.");
            public static final OptionID RANDOM_ID = new OptionID("projections.seed", "Random generator.");
            double window;
            int projections = -1;
            RandomProjectionFamily proj;
            RandomFactory random;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                RandomParameter randomParameter;
                super.makeOptions(parameterization);
                DoubleParameter doubleParameter = new DoubleParameter(WINDOW_ID, 10.0);
                if (parameterization.grab(doubleParameter)) {
                    this.window = (Double)doubleParameter.getValue();
                }
                IntParameter intParameter = new IntParameter(PROJECTIONS_ID);
                intParameter.setOptional(true);
                intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.projections = (Integer)intParameter.getValue();
                }
                ObjectParameter objectParameter = new ObjectParameter(PROJECTION_ID, RandomProjectionFamily.class);
                objectParameter.setOptional(true);
                if (parameterization.grab(objectParameter)) {
                    this.proj = (RandomProjectionFamily)objectParameter.instantiateClass(parameterization);
                }
                if (parameterization.grab(randomParameter = new RandomParameter(RANDOM_ID))) {
                    this.random = (RandomFactory)randomParameter.getValue();
                }
            }

            @Override
            protected Factory<?> makeInstance() {
                return new Factory(this.window, this.projections, this.proj, this.random);
            }
        }
    }

    protected class NaiveProjectedKNNQuery
    implements KNNQuery<O> {
        DistanceQuery<O> distq;

        public NaiveProjectedKNNQuery(DistanceQuery<O> distanceQuery) {
            this.distq = distanceQuery;
        }

        @Override
        public KNNList getKNNForDBID(DBIDRef dBIDRef, int n) {
            Object object;
            int n2;
            int n3 = (int)Math.ceil(NaiveProjectedKNNPreprocessor.this.window * (double)n);
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(2 * n3 * NaiveProjectedKNNPreprocessor.this.projected.size());
            int[] nArray = (int[])NaiveProjectedKNNPreprocessor.this.positions.get(dBIDRef);
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object = NaiveProjectedKNNPreprocessor.this.projected.get(n2).iter();
                object.seek(Math.max(0, nArray[n2] - n3));
                for (int i = n3 << 1; i >= 0 && object.valid(); --i) {
                    hashSetModifiableDBIDs.add((DBIDRef)object);
                    object.advance();
                }
            }
            n2 = 0;
            object = DBIDUtil.newHeap(n);
            NumberVector numberVector = (NumberVector)NaiveProjectedKNNPreprocessor.this.relation.get(dBIDRef);
            DBIDMIter dBIDMIter = hashSetModifiableDBIDs.iter();
            while (dBIDMIter.valid()) {
                object.insert(this.distq.distance((DBIDMIter)((Object)numberVector), dBIDMIter), dBIDMIter);
                ++n2;
                dBIDMIter.advance();
            }
            NaiveProjectedKNNPreprocessor.this.mean.put((double)n2 / (double)n);
            return object.toKNNList();
        }

        @Override
        public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
            throw new AbortException("Not yet implemented");
        }

        @Override
        public KNNList getKNNForObject(O o, int n) {
            throw new AbortException("Not yet implemented");
        }
    }
}

