/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.preference;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.AbstractPreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.PreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="HiSC Preprocessor")
@Description(value="Computes the preference vector of objects of a certain database according to the HiSC algorithm.")
public class HiSCPreferenceVectorIndex<V extends NumberVector>
extends AbstractPreferenceVectorIndex<V>
implements PreferenceVectorIndex<V> {
    private static final Logging LOG = Logging.getLogger(HiSCPreferenceVectorIndex.class);
    protected double alpha;
    protected int k;

    public HiSCPreferenceVectorIndex(Relation<V> relation, double d, int n) {
        super(relation);
        this.alpha = d;
        this.k = n;
    }

    @Override
    public void initialize() {
        if (this.relation == null || this.relation.size() <= 0) {
            throw new IllegalArgumentException("database empty: must contain elements");
        }
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, long[].class);
        StringBuilder stringBuilder = new StringBuilder();
        long l = System.currentTimeMillis();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Preprocessing preference vector", this.relation.size(), LOG) : null;
        KNNQuery<NumberVector> kNNQuery = QueryUtil.getKNNQuery(this.relation, EuclideanDistanceFunction.STATIC, this.k);
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            if (LOG.isDebugging()) {
                stringBuilder.append("\n\nid = ").append(DBIDUtil.toString(dBIDIter));
                stringBuilder.append("\n knns: ");
            }
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k);
            long[] lArray = this.determinePreferenceVector(this.relation, dBIDIter, kNNList, stringBuilder);
            this.storage.put(dBIDIter, lArray);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        if (LOG.isDebugging()) {
            LOG.debugFine(stringBuilder.toString());
        }
        long l2 = System.currentTimeMillis();
        if (LOG.isVerbose()) {
            long l3 = l2 - l;
            LOG.verbose(this.getClass().getName() + " runtime: " + l3 + " milliseconds.");
        }
    }

    private long[] determinePreferenceVector(Relation<V> relation, DBIDRef dBIDRef, DBIDs dBIDs, StringBuilder stringBuilder) {
        double[] dArray = RelationUtil.variances(relation, (NumberVector)relation.get(dBIDRef), dBIDs);
        long[] lArray = BitsUtil.zero(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < this.alpha)) continue;
            BitsUtil.setI(lArray, i);
        }
        if (stringBuilder != null && LOG.isDebugging()) {
            stringBuilder.append("\nalpha ").append(this.alpha);
            stringBuilder.append("\nvariances ");
            stringBuilder.append(FormatUtil.format(dArray, ", ", FormatUtil.NF4));
            stringBuilder.append("\npreference ");
            stringBuilder.append(BitsUtil.toStringLow(lArray, dArray.length));
        }
        return lArray;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "HiSC Preference Vectors";
    }

    @Override
    public String getShortName() {
        return "hisc-pref";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<V extends NumberVector>
    extends AbstractPreferenceVectorIndex.Factory<V, HiSCPreferenceVectorIndex<V>> {
        public static final double DEFAULT_ALPHA = 0.01;
        public static final OptionID ALPHA_ID = new OptionID("hisc.alpha", "The maximum absolute variance along a coordinate axis.");
        public static final OptionID K_ID = new OptionID("hisc.k", "The number of nearest neighbors considered to determine the preference vector. If this value is not defined, k ist set to three times of the dimensionality of the database objects.");
        protected double alpha;
        protected Integer k;

        public Factory(double d, Integer n) {
            this.alpha = d;
            this.k = n;
        }

        @Override
        public HiSCPreferenceVectorIndex<V> instantiate(Relation<V> relation) {
            int n = this.k == null ? 3 * RelationUtil.dimensionality(relation) : this.k;
            return new HiSCPreferenceVectorIndex<V>(relation, this.alpha, n);
        }

        public static class Parameterizer<V extends NumberVector>
        extends AbstractParameterizer {
            protected double alpha;
            protected Integer k;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                super.makeOptions(parameterization);
                DoubleParameter doubleParameter = new DoubleParameter(ALPHA_ID, 0.01);
                doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
                doubleParameter.addConstraint(CommonConstraints.LESS_THAN_ONE_DOUBLE);
                if (parameterization.grab(doubleParameter)) {
                    this.alpha = doubleParameter.doubleValue();
                }
                IntParameter intParameter = new IntParameter(K_ID);
                intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                intParameter.setOptional(true);
                if (parameterization.grab(intParameter)) {
                    this.k = intParameter.intValue();
                }
            }

            @Override
            protected Factory<V> makeInstance() {
                return new Factory(this.alpha, this.k);
            }
        }
    }
}

