/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ApproximationLine
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private double m;
    private double t;
    private int k_0;

    public ApproximationLine() {
    }

    public ApproximationLine(int n, double d, double d2) {
        this.k_0 = n;
        this.m = d;
        this.t = d2;
    }

    public double getM() {
        return this.m;
    }

    public double getT() {
        return this.t;
    }

    public int getK_0() {
        return this.k_0;
    }

    public double getValueAt(int n) {
        if (n < this.k_0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.m * StrictMath.log(n) + this.t;
    }

    public double getApproximatedKnnDistance(int n) {
        if (n < this.k_0) {
            return 0.0;
        }
        return Math.exp(this.getValueAt(n));
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.m);
        objectOutput.writeDouble(this.t);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.m = objectInput.readDouble();
        this.t = objectInput.readDouble();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ApproximationLine approximationLine = (ApproximationLine)object;
        return Double.compare(approximationLine.m, this.m) == 0 && Double.compare(approximationLine.t, this.t) == 0;
    }

    public int hashCode() {
        long l = this.m != 0.0 ? Double.doubleToLongBits(this.m) : 0L;
        int n = (int)(l ^ l >>> 32);
        l = this.t != 0.0 ? Double.doubleToLongBits(this.t) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public String toString() {
        return "m = " + this.m + ", t = " + this.t + " k_0 " + this.k_0;
    }
}

