/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.AbstractCovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.weightfunctions.ConstantWeight;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.weightfunctions.WeightFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="Weighted Covariance Matrix / PCA")
@Description(value="A PCA modification by using weights while building the covariance matrix, to obtain more stable results")
@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="A General Framework for Increasing the Robustness of PCA-based Correlation Clustering Algorithms", booktitle="Proceedings of the 20th International Conference on Scientific and Statistical Database Management (SSDBM), Hong Kong, China, 2008", url="http://dx.doi.org/10.1007/978-3-540-69497-7_27")
public class WeightedCovarianceMatrixBuilder
extends AbstractCovarianceMatrixBuilder {
    protected WeightFunction weightfunction;
    private PrimitiveDistanceFunction<? super NumberVector> weightDistance = EuclideanDistanceFunction.STATIC;

    public WeightedCovarianceMatrixBuilder(WeightFunction weightFunction) {
        this.weightfunction = weightFunction;
    }

    @Override
    public Matrix processIds(DBIDs dBIDs, Relation<? extends NumberVector> relation) {
        double d;
        NumberVector numberVector;
        int n = RelationUtil.dimensionality(relation);
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(n);
        Centroid centroid = Centroid.make(relation, dBIDs);
        double d2 = 0.0;
        double d3 = 0.0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            numberVector = relation.get(dBIDIter);
            d = this.weightDistance.distance(centroid, numberVector);
            d3 += d * d;
            if (d > d2) {
                d2 = d;
            }
            dBIDIter.advance();
        }
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        d3 = Math.sqrt(d3 / (double)dBIDs.size());
        dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            numberVector = relation.get(dBIDIter);
            d = this.weightDistance.distance(centroid, numberVector);
            double d4 = this.weightfunction.getWeight(d, d2, d3);
            covarianceMatrix.put(numberVector, d4);
            dBIDIter.advance();
        }
        return covarianceMatrix.destroyToNaiveMatrix();
    }

    @Override
    public Matrix processQueryResults(DoubleDBIDList doubleDBIDList, Relation<? extends NumberVector> relation, int n) {
        double d;
        int n2 = RelationUtil.dimensionality(relation);
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(n2);
        if (n > doubleDBIDList.size()) {
            n = doubleDBIDList.size();
        }
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
        while (doubleDBIDListIter.valid() && n3 < n) {
            d = doubleDBIDListIter.doubleValue();
            d3 += d * d;
            if (d > d2) {
                d2 = d;
            }
            doubleDBIDListIter.advance();
            ++n;
        }
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        d3 = Math.sqrt(d3 / (double)n);
        n3 = 0;
        doubleDBIDListIter = doubleDBIDList.iter();
        while (doubleDBIDListIter.valid() && n3 < n) {
            d = doubleDBIDListIter.doubleValue();
            NumberVector numberVector = relation.get(doubleDBIDListIter);
            double d4 = this.weightfunction.getWeight(d, d2, d3);
            covarianceMatrix.put(numberVector, d4);
            doubleDBIDListIter.advance();
            ++n;
        }
        return covarianceMatrix.destroyToNaiveMatrix();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID WEIGHT_ID = new OptionID("pca.weight", "Weight function to use in weighted PCA.");
        protected WeightFunction weightfunction = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(WEIGHT_ID, (Class<?>)WeightFunction.class, ConstantWeight.class);
            if (parameterization.grab(objectParameter)) {
                this.weightfunction = (WeightFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected WeightedCovarianceMatrixBuilder makeInstance() {
            return new WeightedCovarianceMatrixBuilder(this.weightfunction);
        }
    }
}

