/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class WeibullDistribution
extends AbstractDistribution {
    double theta = 0.0;
    double k;
    double lambda;

    public WeibullDistribution(double d, double d2) {
        this(d, d2, 0.0, (Random)null);
    }

    public WeibullDistribution(double d, double d2, double d3) {
        this(d, d2, d3, (Random)null);
    }

    public WeibullDistribution(double d, double d2, Random random) {
        this(d, d2, 0.0, random);
    }

    public WeibullDistribution(double d, double d2, double d3, Random random) {
        super(random);
        this.k = d;
        this.lambda = d2;
        this.theta = d3;
    }

    public WeibullDistribution(double d, double d2, double d3, RandomFactory randomFactory) {
        super(randomFactory);
        this.k = d;
        this.lambda = d2;
        this.theta = d3;
    }

    @Override
    public double pdf(double d) {
        return WeibullDistribution.pdf(d, this.k, this.lambda, this.theta);
    }

    public static double pdf(double d, double d2, double d3, double d4) {
        if (d > d4) {
            double d5 = (d - d4) / d3;
            return d2 / d3 * Math.pow(d5, d2 - 1.0) * Math.exp(-Math.pow(d5, d2));
        }
        return 0.0;
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        if (d > d4) {
            return 1.0 - Math.exp(-Math.pow((d - d4) / d3, d2));
        }
        return 0.0;
    }

    @Override
    public double cdf(double d) {
        return WeibullDistribution.cdf(d, this.k, this.lambda, this.theta);
    }

    public static double quantile(double d, double d2, double d3, double d4) {
        if (d < 0.0 || d > 1.0) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return d4 + d3 * Math.pow(-Math.log(1.0 - d), 1.0 / d2);
    }

    @Override
    public double quantile(double d) {
        return WeibullDistribution.quantile(d, this.k, this.lambda, this.theta);
    }

    @Override
    public double nextRandom() {
        return this.theta + this.lambda * Math.pow(-Math.log(1.0 - this.random.nextDouble()), 1.0 / this.k);
    }

    @Override
    public String toString() {
        return "WeibullDistribution(k=" + this.k + ", lambda=" + this.lambda + ", theta=" + this.theta + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double theta;
        double k;
        double lambda;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            DoubleParameter doubleParameter2;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter3 = new DoubleParameter(LOCATION_ID, 0.0);
            if (parameterization.grab(doubleParameter3)) {
                this.theta = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter2 = new DoubleParameter(SCALE_ID))) {
                this.lambda = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHAPE_ID))) {
                this.k = doubleParameter.doubleValue();
            }
        }

        @Override
        protected WeibullDistribution makeInstance() {
            return new WeibullDistribution(this.theta, this.k, this.lambda, this.rnd);
        }
    }
}

