/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.LongHistogram;
import java.util.Arrays;

public class LongStaticHistogram
extends AbstractStaticHistogram
implements LongHistogram {
    long[] data;

    public LongStaticHistogram(int n, double d, double d2) {
        super(n, d, d2);
        this.data = (long[])(n >= 0 ? new long[n] : null);
    }

    @Override
    public void increment(double d, long l) {
        int n = this.getBinNr(d);
        if (n < 0) {
            if (this.size - n > this.data.length) {
                long[] lArray = new long[LongStaticHistogram.growSize(this.data.length, this.size - n)];
                System.arraycopy(this.data, 0, lArray, -n, this.size);
                this.data = lArray;
            } else {
                System.arraycopy(this.data, 0, this.data, -n, this.size);
                Arrays.fill(this.data, 0, -n, 0L);
            }
            this.data[0] = l;
            assert (this.data.length >= this.size - n);
            this.offset -= n;
            this.size -= n;
        } else if (n >= this.data.length) {
            long[] lArray = new long[LongStaticHistogram.growSize(this.data.length, n + 1)];
            System.arraycopy(this.data, 0, lArray, 0, this.size);
            lArray[n] = l;
            this.data = lArray;
            this.size = n + 1;
            this.max = Double.MAX_VALUE;
        } else {
            if (n >= this.size) {
                this.size = n + 1;
            }
            int n2 = n;
            this.data[n2] = this.data[n2] + l;
        }
    }

    public long get(double d) {
        int n = this.getBinNr(d);
        if (n < 0 || n >= this.size) {
            return 0L;
        }
        return this.data[n];
    }

    @Override
    public Iter iter() {
        return new Iter();
    }

    public class Iter
    extends AbstractStaticHistogram.Iter
    implements LongHistogram.Iter {
        public Iter() {
            super(LongStaticHistogram.this);
        }

        @Override
        public long getValue() {
            return LongStaticHistogram.this.data[this.bin];
        }
    }
}

