/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization;

import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;

public class VisualizationTask
implements VisualizationItem,
Comparable<VisualizationTask> {
    public int level = 0;
    public boolean visible = true;
    private int flags;
    public static final int FLAG_NO_THUMBNAIL = 1;
    public static final int FLAG_NO_DETAIL = 2;
    public static final int FLAG_NO_EXPORT = 4;
    public static final int FLAG_NO_EMBED = 8;
    public boolean default_visibility = true;
    public boolean tool = false;
    public static final int LEVEL_BACKGROUND = 0;
    public static final int LEVEL_DATA = 100;
    public static final int LEVEL_STATIC = 200;
    public static final int LEVEL_FOREGROUND = 300;
    public static final int LEVEL_INTERACTIVE = 1000;
    public int updatemask;
    public static final int ON_DATA = 1;
    public static final int ON_SELECTION = 2;
    public static final int ON_STYLEPOLICY = 4;
    public static final int ON_SAMPLE = 8;
    String name;
    VisualizerContext context;
    VisFactory factory;
    Object result;
    Relation<?> relation;
    public double reqwidth;
    public double reqheight;

    public VisualizationTask(String string, VisualizerContext visualizerContext, Object object, Relation<?> relation, VisFactory visFactory) {
        this.name = string;
        this.context = visualizerContext;
        this.result = object;
        this.relation = relation;
        this.factory = visFactory;
    }

    public VisualizerContext getContext() {
        return this.context;
    }

    public VisFactory getFactory() {
        return this.factory;
    }

    public <R> R getResult() {
        return (R)this.result;
    }

    public <R extends Relation<?>> R getRelation() {
        return (R)this.relation;
    }

    public void initDefaultVisibility(boolean bl) {
        this.visible = bl;
        this.default_visibility = bl;
    }

    @Override
    public String getMenuName() {
        return this.name;
    }

    @Override
    public int compareTo(VisualizationTask visualizationTask) {
        if (this.level != visualizationTask.level) {
            return this.level - visualizationTask.level;
        }
        String string = this.getMenuName();
        String string2 = visualizationTask.getMenuName();
        if (string != null && string2 != null && string != string2) {
            return string.compareTo(string2);
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("VisTask: ").append(this.factory.getClass().getName()).append(' ');
        if (this.result != null && this.result instanceof Result) {
            stringBuilder.append("Result: ").append(((Result)this.result).getLongName()).append(' ');
        }
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void addUpdateFlags(int n) {
        this.updatemask |= n;
    }

    public boolean updateOnAny(int n) {
        return (this.updatemask & n) != 0;
    }

    public boolean hasAnyFlags(int n) {
        return (this.flags & n) != 0;
    }

    public void addFlags(int n) {
        this.flags |= n;
    }
}

