/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.selection;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.RangeSelection;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;

public class SelectionAxisRangeVisualization
extends AbstractVisFactory {
    public static final String NAME = "Selection Axis Range";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ParallelPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ParallelPlotProjector.class);
        while (iter.valid()) {
            ParallelPlotProjector parallelPlotProjector = iter.get();
            Relation relation = parallelPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, visualizerContext.getSelectionResult(), relation, this);
                visualizationTask.level = 99;
                visualizationTask.addUpdateFlags(2);
                visualizerContext.addVis(visualizerContext.getSelectionResult(), visualizationTask);
                visualizerContext.addVis(parallelPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector> {
        public static final String MARKER = "selectionAxisRange";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        private void addCSSClasses(SVGPlot sVGPlot) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            if (!sVGPlot.getCSSClassManager().contains(MARKER)) {
                CSSClass cSSClass = new CSSClass(this, MARKER);
                cSSClass.setStatement("stroke", styleLibrary.getColor("plot.selection"));
                cSSClass.setStatement("stroke-opacity", styleLibrary.getOpacity("plot.selection"));
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot"));
                cSSClass.setStatement("stroke-linecap", "round");
                cSSClass.setStatement("stroke-linejoin", "round");
                cSSClass.setStatement("fill", styleLibrary.getColor("plot.selection"));
                cSSClass.setStatement("fill-opacity", styleLibrary.getOpacity("plot.selection"));
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }

        @Override
        public void fullRedraw() {
            int n;
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            DBIDSelection dBIDSelection = this.context.getSelection();
            if (!(dBIDSelection instanceof RangeSelection)) {
                return;
            }
            ModifiableHyperBoundingBox modifiableHyperBoundingBox = ((RangeSelection)dBIDSelection).getRanges();
            if (modifiableHyperBoundingBox == null) {
                return;
            }
            int n2 = modifiableHyperBoundingBox.getDimensionality();
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            for (n = 0; n < n2; ++n) {
                dArray[n] = modifiableHyperBoundingBox.getMin(n);
                dArray2[n] = modifiableHyperBoundingBox.getMax(n);
            }
            dArray = this.proj.fastProjectDataToRenderSpace(dArray);
            dArray2 = this.proj.fastProjectDataToRenderSpace(dArray2);
            n = this.proj.getVisibleDimensions();
            for (int i = 0; i < n; ++i) {
                int n3 = this.proj.getDimForVisibleAxis(i);
                double d = Math.min(dArray[n3], dArray2[n3]);
                double d2 = Math.max(dArray[n3], dArray2[n3]);
                if (!(d > Double.MIN_VALUE) || !(d2 < Double.MAX_VALUE)) continue;
                Element element = this.svgp.svgRect(this.getVisibleAxisX(i) - 1.0, d, 2.0, d2 - d);
                SVGUtil.addCSSClass(element, MARKER);
                this.layer.appendChild(element);
            }
        }
    }
}

