/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.density;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.KMLOutputHandler;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.ThumbnailRegistryEntry;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import org.w3c.dom.Element;

public class DensityEstimationOverlay
extends AbstractVisFactory {
    private static final String NAME = "Density estimation overlay";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, relation, scatterPlotProjector.getRelation(), this);
                visualizationTask.level = 101;
                visualizationTask.addUpdateFlags(1);
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        private int resolution;
        private BufferedImage img;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.resolution = 500;
            this.img = null;
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            if (this.img == null) {
                this.renderImage();
            }
            CanvasSize canvasSize = this.proj.estimateViewport();
            String string = "thumb:" + ThumbnailRegistryEntry.registerImage(this.img);
            Element element = this.svgp.svgElement("image");
            SVGUtil.setAtt(element, "image-rendering", "optimizeSpeed");
            SVGUtil.setAtt(element, "x", canvasSize.minx);
            SVGUtil.setAtt(element, "y", canvasSize.miny);
            SVGUtil.setAtt(element, "width", canvasSize.maxx - canvasSize.minx);
            SVGUtil.setAtt(element, "height", canvasSize.maxy - canvasSize.miny);
            SVGUtil.setAtt(element, "style", "opacity: .5");
            element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", string);
            this.layer.appendChild(element);
        }

        @Reference(authors="D. W. Scott", title="Multivariate density estimation: Theory, Practice, and Visualization", booktitle="Multivariate Density Estimation: Theory, Practice, and Visualization", url="http://dx.doi.org/10.1002/9780470316849")
        private double[] initializeBandwidth(double[][] dArray) {
            MeanVariance meanVariance = new MeanVariance();
            MeanVariance meanVariance2 = new MeanVariance();
            for (double[] dArray2 : dArray) {
                meanVariance.put(dArray2[0]);
                meanVariance2.put(dArray2[1]);
            }
            double[] dArray3 = new double[]{MathUtil.SQRT5 * meanVariance.getSampleStddev() * Math.pow(this.rel.size(), -0.16666666666666666), MathUtil.SQRT5 * meanVariance2.getSampleStddev() * Math.pow(this.rel.size(), -0.16666666666666666)};
            return dArray3;
        }

        private void renderImage() {
            int n;
            double[][] dArrayArray = new double[this.rel.size()][];
            int n2 = 0;
            Object object = this.rel.iterDBIDs();
            while (object.valid()) {
                dArrayArray[n2] = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get((DBIDRef)object));
                ++n2;
                object.advance();
            }
            double[] dArray = this.initializeBandwidth(dArrayArray);
            object = new Comparator<double[]>(){

                @Override
                public int compare(double[] dArray, double[] dArray2) {
                    return Double.compare(dArray[0], dArray2[0]);
                }
            };
            Comparator<double[]> comparator = new Comparator<double[]>(){

                @Override
                public int compare(double[] dArray, double[] dArray2) {
                    return Double.compare(dArray[1], dArray2[1]);
                }
            };
            Arrays.sort(dArrayArray, object);
            CanvasSize canvasSize = this.proj.estimateViewport();
            double d = canvasSize.minx;
            double d2 = canvasSize.maxx;
            double d3 = (d2 - d) / (double)this.resolution;
            double d4 = canvasSize.miny;
            double d5 = canvasSize.maxy;
            double d6 = (d5 - d4) / (double)this.resolution;
            double d7 = 9.0 / (16.0 * dArray[0] * dArray[1]);
            double d8 = 0.0;
            double[][] dArray2 = new double[this.resolution][this.resolution];
            for (n = 0; n < this.resolution; ++n) {
                double d9 = d + d3 * (double)n;
                double d10 = d9 + d3;
                int n3 = this.unflip(Arrays.binarySearch(dArrayArray, new double[]{d9 - dArray[0]}, object));
                int n4 = this.unflip(Arrays.binarySearch(dArrayArray, new double[]{d10 + dArray[0]}, object));
                Arrays.sort(dArrayArray, n3, n4, comparator);
                for (int i = 0; i < this.resolution; ++i) {
                    double d11 = d4 + d6 * (double)i;
                    double d12 = d11 + d6;
                    int n5 = this.unflip(Arrays.binarySearch(dArrayArray, n3, n4, new double[]{0.0, d11 - dArray[1]}, comparator));
                    int n6 = this.unflip(Arrays.binarySearch(dArrayArray, n3, n4, new double[]{0.0, d12 + dArray[1]}, comparator));
                    for (int j = n5; j < n6; ++j) {
                        double d13;
                        double[] dArray3 = dArrayArray[j];
                        double d14 = dArray3[0] < d9 ? d9 - dArray3[0] : (d13 = dArray3[0] > d10 ? dArray3[0] - d10 : 0.0);
                        double d15 = dArray3[1] < d11 ? d11 - dArray3[1] : (dArray3[1] > d12 ? dArray3[1] - d12 : 0.0);
                        double[] dArray4 = dArray2[n];
                        int n7 = i;
                        dArray4[n7] = dArray4[n7] + d7 * (1.0 - (d13 /= dArray[0]) * d13) * (1.0 - (d15 /= dArray[1]) * d15);
                    }
                    d8 = Math.max(d8, dArray2[n][i]);
                }
                Arrays.sort(dArrayArray, n3, n4, object);
            }
            this.img = new BufferedImage(this.resolution, this.resolution, 2);
            for (n = 0; n < this.resolution; ++n) {
                for (int i = 0; i < this.resolution; ++i) {
                    int n8 = KMLOutputHandler.getColorForValue(dArray2[n][i] / d8).getRGB();
                    this.img.setRGB(n, i, n8);
                }
            }
        }

        private int unflip(int n) {
            if (n < 0) {
                return -n - 1;
            }
            return n;
        }
    }
}

