/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import org.jgap.Configuration;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.ICloneHandler;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.Population;

public abstract class NaturalSelectorExt
extends NaturalSelector {
    private Population m_to_pop;
    private boolean m_doublettesAllowed;

    public NaturalSelectorExt() throws InvalidConfigurationException {
        this.init(Genotype.getStaticConfiguration());
    }

    public NaturalSelectorExt(Configuration a_config) throws InvalidConfigurationException {
        super(a_config);
        this.init(a_config);
    }

    protected void init(Configuration a_config) throws InvalidConfigurationException {
    }

    public void setDoubletteChromosomesAllowed(boolean a_doublettesAllowed) {
        this.m_doublettesAllowed = a_doublettesAllowed;
    }

    public boolean getDoubletteChromosomesAllowed() {
        return this.m_doublettesAllowed;
    }

    public boolean equals(Object a_o) {
        if (a_o == null) {
            return false;
        }
        NaturalSelectorExt other = (NaturalSelectorExt)a_o;
        if (!super.equals(a_o)) {
            return false;
        }
        return this.m_doublettesAllowed == other.m_doublettesAllowed;
    }

    protected abstract void add(IChromosome var1);

    public final synchronized void select(int a_howManyToSelect, Population a_from_pop, Population a_to_pop) {
        if (a_from_pop != null) {
            int popSize = a_from_pop.size();
            if (popSize < 1) {
                throw new IllegalStateException("Population size must be greater 0");
            }
            for (int i = 0; i < popSize; ++i) {
                this.add(a_from_pop.getChromosome(i));
            }
        }
        this.selectChromosomes(a_howManyToSelect, a_to_pop);
    }

    protected abstract void selectChromosomes(int var1, Population var2);

    protected final void selectChromosome(IChromosome a_chrom, boolean a_clone) {
        if (a_clone && !this.m_to_pop.contains(a_chrom)) {
            ICloneHandler cloner = this.getConfiguration().getJGAPFactory().getCloneHandlerFor(a_chrom, null);
            if (cloner != null) {
                try {
                    IChromosome original = a_chrom;
                    a_chrom = (IChromosome)cloner.perform(original, null, null);
                    a_chrom.setIsSelectedForNextGeneration(true);
                    this.m_to_pop.addChromosome(a_chrom);
                    if (this.m_monitorActive) {
                        a_chrom.setUniqueIDTemplate(original.getUniqueID(), 1);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            this.m_to_pop.addChromosome(a_chrom);
        }
    }
}

