/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.AbstractNumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class IntegerVector
extends AbstractNumberVector {
    public static final Factory STATIC = new Factory();
    public static final ByteBufferSerializer<IntegerVector> BYTE_SERIALIZER = new SmallSerializer();
    public static final ByteBufferSerializer<IntegerVector> SHORT_SERIALIZER = new ShortSerializer();
    public static final ByteBufferSerializer<IntegerVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final int[] values;

    private IntegerVector(int[] nArray, boolean bl) {
        if (bl) {
            this.values = nArray;
        } else {
            this.values = new int[nArray.length];
            System.arraycopy(nArray, 0, this.values, 0, nArray.length);
        }
    }

    public IntegerVector(int[] nArray) {
        this.values = (int[])nArray.clone();
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    @Deprecated
    public Integer getValue(int n) {
        return this.values[n];
    }

    @Override
    public double doubleValue(int n) {
        return this.values[n];
    }

    @Override
    public long longValue(int n) {
        return this.values[n];
    }

    @Override
    public int intValue(int n) {
        return this.values[n];
    }

    public int[] getValues() {
        int[] nArray = new int[this.values.length];
        System.arraycopy(this.values, 0, nArray, 0, this.values.length);
        return nArray;
    }

    @Override
    public Vector getColumnVector() {
        double[] dArray = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            dArray[i] = this.values[i];
        }
        return new Vector(dArray);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            stringBuilder.append(this.values[i]);
            if (i + 1 >= this.values.length) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<IntegerVector> {
        @Override
        public IntegerVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            assert (byteBuffer.remaining() >= 4 * n);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = ByteArrayUtil.readSignedVarint(byteBuffer);
            }
            return new IntegerVector(nArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, IntegerVector integerVector) throws IOException {
            assert (integerVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, integerVector.values.length);
            for (int i = 0; i < integerVector.values.length; ++i) {
                ByteArrayUtil.writeSignedVarint(byteBuffer, integerVector.values[i]);
            }
        }

        @Override
        public int getByteSize(IntegerVector integerVector) {
            assert (integerVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            int n = ByteArrayUtil.getUnsignedVarintSize(integerVector.values.length);
            for (int i = 0; i < integerVector.values.length; ++i) {
                n += ByteArrayUtil.getSignedVarintSize(integerVector.values[i]);
            }
            return n;
        }
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<IntegerVector> {
        @Override
        public IntegerVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.getShort();
            assert (byteBuffer.remaining() >= 4 * n);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = byteBuffer.getInt();
            }
            return new IntegerVector(nArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, IntegerVector integerVector) throws IOException {
            assert (integerVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (byteBuffer.remaining() >= 4 * integerVector.values.length);
            byteBuffer.putShort((short)integerVector.values.length);
            for (int i = 0; i < integerVector.values.length; ++i) {
                byteBuffer.putInt(integerVector.values[i]);
            }
        }

        @Override
        public int getByteSize(IntegerVector integerVector) {
            assert (integerVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return 2 + 4 * integerVector.getDimensionality();
        }
    }

    public static class SmallSerializer
    implements ByteBufferSerializer<IntegerVector> {
        @Override
        public IntegerVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.get();
            assert (byteBuffer.remaining() >= 4 * n);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = byteBuffer.getInt();
            }
            return new IntegerVector(nArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, IntegerVector integerVector) throws IOException {
            assert (integerVector.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            assert (byteBuffer.remaining() >= 4 * integerVector.values.length);
            byteBuffer.put((byte)integerVector.values.length);
            for (int i = 0; i < integerVector.values.length; ++i) {
                byteBuffer.putInt(integerVector.values[i]);
            }
        }

        @Override
        public int getByteSize(IntegerVector integerVector) {
            assert (integerVector.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            return 1 + 4 * integerVector.getDimensionality();
        }
    }

    public static class Factory
    extends AbstractNumberVector.Factory<IntegerVector> {
        @Override
        public <A> IntegerVector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            int n = arrayAdapter.size(a);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = arrayAdapter.get(a, i).intValue();
            }
            return new IntegerVector(nArray, true);
        }

        @Override
        public <A> IntegerVector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            int n = numberArrayAdapter.size(a);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = numberArrayAdapter.getInteger(a, i);
            }
            return new IntegerVector(nArray, true);
        }

        @Override
        public ByteBufferSerializer<IntegerVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super IntegerVector> getRestrictionClass() {
            return IntegerVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return STATIC;
            }
        }
    }
}

