/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.wfg;

import java.util.logging.Level;
import org.uma.jmetal.problem.multiobjective.wfg.Shapes;
import org.uma.jmetal.problem.multiobjective.wfg.Transformations;
import org.uma.jmetal.problem.multiobjective.wfg.WFG;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;

public class WFG1
extends WFG {
    public WFG1() throws ClassNotFoundException, JMetalException {
        this(2, 4, 2);
    }

    public WFG1(Integer k, Integer l, Integer m) throws ClassNotFoundException, JMetalException {
        super(k, l, m);
        int i;
        this.setName("WFG1");
        this.s = new int[m.intValue()];
        for (i = 0; i < m; ++i) {
            this.s[i] = 2 * (i + 1);
        }
        this.a = new int[m - 1];
        for (i = 0; i < m - 1; ++i) {
            this.a[i] = 1;
        }
    }

    @Override
    public float[] evaluate(float[] z) {
        float[] y = this.normalise(z);
        y = this.t1(y, this.k);
        y = this.t2(y, this.k);
        try {
            y = this.t3(y);
        }
        catch (JMetalException e) {
            JMetalLogger.logger.log(Level.SEVERE, "Error", e);
        }
        y = this.t4(y, this.k, this.m);
        float[] result = new float[this.m];
        float[] x = this.calculateX(y);
        for (int m = 1; m <= this.m - 1; ++m) {
            result[m - 1] = (float)this.d * x[this.m - 1] + (float)this.s[m - 1] * new Shapes().convex(x, m);
        }
        result[this.m - 1] = (float)this.d * x[this.m - 1] + (float)this.s[this.m - 1] * new Shapes().mixed(x, 5, 1.0f);
        return result;
    }

    public float[] t1(float[] z, int k) {
        float[] result = new float[z.length];
        System.arraycopy(z, 0, result, 0, k);
        for (int i = k; i < z.length; ++i) {
            result[i] = new Transformations().sLinear(z[i], 0.35f);
        }
        return result;
    }

    public float[] t2(float[] z, int k) {
        float[] result = new float[z.length];
        System.arraycopy(z, 0, result, 0, k);
        for (int i = k; i < z.length; ++i) {
            result[i] = new Transformations().bFlat(z[i], 0.8f, 0.75f, 0.85f);
        }
        return result;
    }

    public float[] t3(float[] z) throws JMetalException {
        float[] result = new float[z.length];
        for (int i = 0; i < z.length; ++i) {
            result[i] = new Transformations().bPoly(z[i], 0.02f);
        }
        return result;
    }

    public float[] t4(float[] z, int k, int M) {
        int i;
        float[] result = new float[M];
        float[] w = new float[z.length];
        for (i = 0; i < z.length; ++i) {
            w[i] = 2.0f * (float)(i + 1);
        }
        for (i = 1; i <= M - 1; ++i) {
            int head = (i - 1) * k / (M - 1) + 1;
            int tail = i * k / (M - 1);
            float[] subZ = this.subVector(z, head - 1, tail - 1);
            float[] subW = this.subVector(w, head - 1, tail - 1);
            result[i - 1] = new Transformations().rSum(subZ, subW);
        }
        int head = k + 1 - 1;
        int tail = z.length - 1;
        float[] subZ = this.subVector(z, head, tail);
        float[] subW = this.subVector(w, head, tail);
        result[M - 1] = new Transformations().rSum(subZ, subW);
        return result;
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        int i;
        float[] variables = new float[this.getNumberOfVariables()];
        double[] x = new double[this.getNumberOfVariables()];
        for (i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        for (i = 0; i < this.getNumberOfVariables(); ++i) {
            variables[i] = (float)x[i];
        }
        float[] f = this.evaluate(variables);
        for (int i2 = 0; i2 < f.length; ++i2) {
            solution.setObjective(i2, f[i2]);
        }
    }
}

