/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.zdt;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class ZDT6
extends AbstractDoubleProblem {
    public ZDT6() {
        this(10);
    }

    public ZDT6(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("ZDT6");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        int numberOfVariables = this.getNumberOfVariables();
        double[] f = new double[this.getNumberOfObjectives()];
        double[] x = new double[numberOfVariables];
        double x1 = (Double)solution.getVariableValue(0);
        f[0] = 1.0 - Math.exp(-4.0 * x1) * Math.pow(Math.sin(Math.PI * 6 * x1), 6.0);
        double g = this.evalG(solution);
        double h = this.evalH(f[0], g);
        f[1] = h * g;
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }

    public double evalG(DoubleSolution solution) {
        double g = 0.0;
        for (int var = 1; var < solution.getNumberOfVariables(); ++var) {
            g += ((Double)solution.getVariableValue(var)).doubleValue();
        }
        g /= (double)(solution.getNumberOfVariables() - 1);
        g = Math.pow(g, 0.25);
        g = 9.0 * g;
        g = 1.0 + g;
        return g;
    }

    public double evalH(double f, double g) {
        return 1.0 - Math.pow(f / g, 2.0);
    }
}

