/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public class FileRenameAction
extends AbstractAction {
    private final File source;
    private final File destination;
    private final boolean renameEmptyFiles;

    public FileRenameAction(File src, File dst, boolean renameEmptyFiles) {
        this.source = src;
        this.destination = dst;
        this.renameEmptyFiles = renameEmptyFiles;
    }

    @Override
    public boolean execute() {
        return FileRenameAction.execute(this.source, this.destination, this.renameEmptyFiles);
    }

    public File getDestination() {
        return this.destination;
    }

    public File getSource() {
        return this.source;
    }

    public boolean isRenameEmptyFiles() {
        return this.renameEmptyFiles;
    }

    public static boolean execute(File source, File destination, boolean renameEmptyFiles) {
        if (renameEmptyFiles || source.length() > 0L) {
            File parent = destination.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
                if (!parent.exists()) {
                    LOGGER.error("Unable to create directory {}", new Object[]{parent.getAbsolutePath()});
                    return false;
                }
            }
            try {
                if (!source.renameTo(destination)) {
                    try {
                        FileRenameAction.copyFile(source, destination);
                        return source.delete();
                    }
                    catch (IOException iex) {
                        LOGGER.error("Unable to rename file {} to {} - {}", new Object[]{source.getAbsolutePath(), destination.getAbsolutePath(), iex.getMessage()});
                    }
                }
                return true;
            }
            catch (Exception ex) {
                try {
                    FileRenameAction.copyFile(source, destination);
                    return source.delete();
                }
                catch (IOException iex) {
                    LOGGER.error("Unable to rename file {} to {} - {}", new Object[]{source.getAbsolutePath(), destination.getAbsolutePath(), iex.getMessage()});
                }
            }
        } else {
            try {
                source.delete();
            }
            catch (Exception ex) {
                LOGGER.error("Unable to delete empty file " + source.getAbsolutePath());
            }
        }
        return false;
    }

    private static void copyFile(File source, File destination) throws IOException {
        if (!destination.exists()) {
            destination.createNewFile();
        }
        try (FileInputStream srcStream = new FileInputStream(source);
             FileOutputStream destStream = new FileOutputStream(destination);
             FileChannel srcChannel = srcStream.getChannel();
             FileChannel destChannel = destStream.getChannel();){
            destChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        }
    }

    public String toString() {
        return FileRenameAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", renameEmptyFiles=" + this.renameEmptyFiles + ']';
    }
}

