/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.AGNES;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.LinkageMethod;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationBuilder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.SingleLinkageMethod;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.WardLinkageMethod;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;

@Reference(authors="M. R. Anderberg", title="Hierarchical Clustering Methods", booktitle="Cluster Analysis for Applications")
public class AnderbergHierarchicalClustering<O>
extends AbstractDistanceBasedAlgorithm<O, PointerHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(AnderbergHierarchicalClustering.class);
    LinkageMethod linkage = WardLinkageMethod.STATIC;

    public AnderbergHierarchicalClustering(DistanceFunction<? super O> distanceFunction, LinkageMethod linkageMethod) {
        super(distanceFunction);
        this.linkage = linkageMethod;
    }

    public PointerHierarchyRepresentationResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(relation.getDBIDs());
        int n = arrayDBIDs.size();
        if (n > 65536) {
            throw new AbortException("This implementation does not scale to data sets larger than 65536 instances (~16 GB RAM), at which point the Java maximum array size is reached.");
        }
        if (SingleLinkageMethod.class.isInstance(this.linkage)) {
            LOG.verbose("Notice: SLINK is a much faster algorithm for single-linkage clustering!");
        }
        double[] dArray = new double[AGNES.triangleSize(n)];
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter();
        boolean bl = WardLinkageMethod.class.isInstance(this.linkage) && !SquaredEuclideanDistanceFunction.class.isInstance(distanceQuery.getDistanceFunction());
        AGNES.initializeDistanceMatrix(dArray, distanceQuery, dBIDArrayIter, dBIDArrayIter2, bl);
        double[] dArray2 = new double[n];
        int[] nArray = new int[n];
        AnderbergHierarchicalClustering.initializeNNCache(dArray, dArray2, nArray);
        PointerHierarchyRepresentationBuilder pointerHierarchyRepresentationBuilder = new PointerHierarchyRepresentationBuilder(arrayDBIDs);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Agglomerative clustering", n - 1, LOG) : null;
        int n2 = n;
        for (int i = 1; i < n; ++i) {
            int n3 = this.findMerge(n2, dArray, dBIDArrayIter, dBIDArrayIter2, dArray2, nArray, pointerHierarchyRepresentationBuilder);
            if (n3 == n2 - 1) {
                dBIDArrayIter.seek(--n2 - 1);
                while (pointerHierarchyRepresentationBuilder.isLinked(dBIDArrayIter)) {
                    --n2;
                    dBIDArrayIter.retract();
                }
            }
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        return pointerHierarchyRepresentationBuilder.complete();
    }

    private static void initializeNNCache(double[] dArray, double[] dArray2, int[] nArray) {
        int n = dArray2.length;
        Arrays.fill(dArray2, Double.POSITIVE_INFINITY);
        Arrays.fill(nArray, -1);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            assert (n2 == AGNES.triangleSize(i));
            double d = Double.POSITIVE_INFINITY;
            int n3 = -1;
            int n4 = 0;
            while (n4 < i) {
                double d2 = dArray[n2];
                if (d2 < dArray2[n4]) {
                    dArray2[n4] = d2;
                    nArray[n4] = i;
                }
                if (d2 < d) {
                    d = d2;
                    n3 = n4;
                }
                ++n4;
                ++n2;
            }
            dArray2[i] = d;
            nArray[i] = n3;
        }
    }

    protected int findMerge(int n, double[] dArray, DBIDArrayIter dBIDArrayIter, DBIDArrayIter dBIDArrayIter2, double[] dArray2, int[] nArray, PointerHierarchyRepresentationBuilder pointerHierarchyRepresentationBuilder) {
        double d = Double.POSITIVE_INFINITY;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] < 0 || !(dArray2[i] < d)) continue;
            d = dArray2[i];
            n2 = i;
            n3 = nArray[i];
        }
        assert (n2 >= 0 && n3 >= 0);
        this.merge(n, dArray, dBIDArrayIter, dBIDArrayIter2, dArray2, nArray, pointerHierarchyRepresentationBuilder, d, n2 < n3 ? n3 : n2, n2 < n3 ? n2 : n3);
        return n2;
    }

    protected void merge(int n, double[] dArray, DBIDArrayIter dBIDArrayIter, DBIDArrayIter dBIDArrayIter2, double[] dArray2, int[] nArray, PointerHierarchyRepresentationBuilder pointerHierarchyRepresentationBuilder, double d, int n2, int n3) {
        dBIDArrayIter.seek(n2);
        dBIDArrayIter2.seek(n3);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Merging: " + DBIDUtil.toString(dBIDArrayIter) + " -> " + DBIDUtil.toString(dBIDArrayIter2) + " " + d);
        }
        assert (n3 < n2);
        pointerHierarchyRepresentationBuilder.add(dBIDArrayIter, d, dBIDArrayIter2);
        int n4 = pointerHierarchyRepresentationBuilder.getSize(dBIDArrayIter);
        int n5 = pointerHierarchyRepresentationBuilder.getSize(dBIDArrayIter2);
        pointerHierarchyRepresentationBuilder.setSize(dBIDArrayIter2, n4 + n5);
        nArray[n2] = -1;
        this.updateMatrix(n, dArray, dBIDArrayIter2, dArray2, nArray, pointerHierarchyRepresentationBuilder, d, n2, n3, n4, n5);
        if (nArray[n3] == n2) {
            this.findBest(n, dArray, dArray2, nArray, n3);
        }
    }

    protected void updateMatrix(int n, double[] dArray, DBIDArrayIter dBIDArrayIter, double[] dArray2, int[] nArray, PointerHierarchyRepresentationBuilder pointerHierarchyRepresentationBuilder, double d, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9 = AGNES.triangleSize(n2);
        int n10 = AGNES.triangleSize(n3);
        for (n8 = 0; n8 < n3; ++n8) {
            if (pointerHierarchyRepresentationBuilder.isLinked(dBIDArrayIter.seek(n8))) continue;
            n7 = pointerHierarchyRepresentationBuilder.getSize(dBIDArrayIter);
            n6 = n10 + n8;
            double d2 = dArray[n6] = this.linkage.combine(n4, dArray[n9 + n8], n5, dArray[n6], n7, d);
            this.updateCache(n, dArray, dArray2, nArray, n2, n3, n8, d2);
        }
        n7 = AGNES.triangleSize(++n8);
        while (n8 < n2) {
            if (!pointerHierarchyRepresentationBuilder.isLinked(dBIDArrayIter.seek(n8))) {
                n6 = pointerHierarchyRepresentationBuilder.getSize(dBIDArrayIter);
                int n11 = n7 + n3;
                double d3 = dArray[n11] = this.linkage.combine(n4, dArray[n9 + n8], n5, dArray[n11], n6, d);
                this.updateCache(n, dArray, dArray2, nArray, n2, n3, n8, d3);
            }
            n7 += n8++;
        }
        n7 += n8++;
        while (n8 < n) {
            if (!pointerHierarchyRepresentationBuilder.isLinked(dBIDArrayIter.seek(n8))) {
                n6 = pointerHierarchyRepresentationBuilder.getSize(dBIDArrayIter);
                double d4 = this.linkage.combine(n4, dArray[n7 + n2], n5, dArray[n7 + n3], n6, d);
                dArray[n7 + n3] = d4;
                double d5 = d4;
                this.updateCache(n, dArray, dArray2, nArray, n2, n3, n8, d5);
            }
            n7 += n8++;
        }
    }

    private void updateCache(int n, double[] dArray, double[] dArray2, int[] nArray, int n2, int n3, int n4, double d) {
        if (d <= dArray2[n4]) {
            dArray2[n4] = d;
            nArray[n4] = n3;
            return;
        }
        if (nArray[n4] == n2 || nArray[n4] == n3) {
            this.findBest(n, dArray, dArray2, nArray, n4);
        }
    }

    protected void findBest(int n, double[] dArray, double[] dArray2, int[] nArray, int n2) {
        int n3 = AGNES.triangleSize(n2);
        double d = Double.POSITIVE_INFINITY;
        int n4 = -1;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n2) {
            if (nArray[n5] >= 0 && dArray[n6] < d) {
                d = dArray[n6];
                n4 = n5;
            }
            ++n5;
            ++n6;
        }
        n6 = n3 + n2 + n2;
        for (n5 = n2 + 1; n5 < n; ++n5) {
            if (nArray[n5] >= 0 && dArray[n6] < d) {
                d = dArray[n6];
                n4 = n5;
            }
            n6 += n5;
        }
        dArray2[n2] = d;
        nArray[n2] = n4;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        protected LinkageMethod linkage;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter = AbstractAlgorithm.makeParameterDistanceFunction(SquaredEuclideanDistanceFunction.class, DistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distanceFunction = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            ObjectParameter objectParameter2 = new ObjectParameter(AGNES.Parameterizer.LINKAGE_ID, LinkageMethod.class);
            objectParameter2.setDefaultValue(WardLinkageMethod.class);
            if (parameterization.grab(objectParameter2)) {
                this.linkage = (LinkageMethod)objectParameter2.instantiateClass(parameterization);
            }
        }

        @Override
        protected AnderbergHierarchicalClustering<O> makeInstance() {
            return new AnderbergHierarchicalClustering(this.distanceFunction, this.linkage);
        }
    }
}

