/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreFactory;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableRecordStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import java.util.Comparator;

public final class DataStoreUtil {
    public static <T> WritableDataStore<T> makeStorage(DBIDs dBIDs, int n, Class<? super T> clazz) {
        return DataStoreFactory.FACTORY.makeStorage(dBIDs, n, clazz);
    }

    public static WritableDBIDDataStore makeDBIDStorage(DBIDs dBIDs, int n) {
        return DataStoreFactory.FACTORY.makeDBIDStorage(dBIDs, n);
    }

    public static WritableDoubleDataStore makeDoubleStorage(DBIDs dBIDs, int n) {
        return DataStoreFactory.FACTORY.makeDoubleStorage(dBIDs, n);
    }

    public static WritableDoubleDataStore makeDoubleStorage(DBIDs dBIDs, int n, double d) {
        return DataStoreFactory.FACTORY.makeDoubleStorage(dBIDs, n, d);
    }

    public static WritableIntegerDataStore makeIntegerStorage(DBIDs dBIDs, int n) {
        return DataStoreFactory.FACTORY.makeIntegerStorage(dBIDs, n);
    }

    public static WritableIntegerDataStore makeIntegerStorage(DBIDs dBIDs, int n, int n2) {
        return DataStoreFactory.FACTORY.makeIntegerStorage(dBIDs, n, n2);
    }

    public static WritableRecordStore makeRecordStorage(DBIDs dBIDs, int n, Class<?> ... classArray) {
        return DataStoreFactory.FACTORY.makeRecordStorage(dBIDs, n, classArray);
    }

    public static class DescendingByDoubleDataStoreAndId
    implements Comparator<DBIDRef> {
        private final DoubleDataStore scores;

        public DescendingByDoubleDataStoreAndId(DoubleDataStore doubleDataStore) {
            this.scores = doubleDataStore;
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            int n = Double.compare(this.scores.doubleValue(dBIDRef2), this.scores.doubleValue(dBIDRef));
            return n != 0 ? n : DBIDUtil.compare(dBIDRef, dBIDRef2);
        }
    }

    public static class AscendingByDoubleDataStoreAndId
    implements Comparator<DBIDRef> {
        private final DoubleDataStore scores;

        public AscendingByDoubleDataStoreAndId(DoubleDataStore doubleDataStore) {
            this.scores = doubleDataStore;
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            int n = Double.compare(this.scores.doubleValue(dBIDRef), this.scores.doubleValue(dBIDRef2));
            return n != 0 ? n : DBIDUtil.compare(dBIDRef, dBIDRef2);
        }
    }

    public static class DescendingByDoubleDataStore
    implements Comparator<DBIDRef> {
        private final DoubleDataStore scores;

        public DescendingByDoubleDataStore(DoubleDataStore doubleDataStore) {
            this.scores = doubleDataStore;
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            return Double.compare(this.scores.doubleValue(dBIDRef2), this.scores.doubleValue(dBIDRef));
        }
    }

    public static class AscendingByDoubleDataStore
    implements Comparator<DBIDRef> {
        private final DoubleDataStore scores;

        public AscendingByDoubleDataStore(DoubleDataStore doubleDataStore) {
            this.scores = doubleDataStore;
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            return Double.compare(this.scores.doubleValue(dBIDRef), this.scores.doubleValue(dBIDRef2));
        }
    }
}

