/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.kd;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.spatial.kd.MinimalisticMemoryKDTree;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="J. L. Bentley", title="Multidimensional binary search trees used for associative searching", booktitle="Communications of the ACM, Vol. 18 Issue 9, Sept. 1975", url="http://dx.doi.org/10.1145/361002.361007")
public class SmallMemoryKDTree<O extends NumberVector>
extends AbstractIndex<O>
implements KNNIndex<O>,
RangeIndex<O> {
    private static final Logging LOG = Logging.getLogger(SmallMemoryKDTree.class);
    ModifiableDoubleDBIDList sorted = null;
    int dims = -1;
    int leafsize;
    final Counter objaccess;
    final Counter distcalc;

    public SmallMemoryKDTree(Relation<O> relation, int n) {
        super(relation);
        this.leafsize = n;
        assert (n >= 1);
        if (LOG.isStatistics()) {
            String string = this.getClass().getName();
            this.objaccess = LOG.newCounter(string + ".objaccess");
            this.distcalc = LOG.newCounter(string + ".distancecalcs");
        } else {
            this.objaccess = null;
            this.distcalc = null;
        }
    }

    @Override
    public void initialize() {
        this.sorted = DBIDUtil.newDistanceDBIDList(this.relation.size());
        this.dims = RelationUtil.dimensionality(this.relation);
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            this.sorted.add(Double.NaN, dBIDIter);
            dBIDIter.advance();
        }
        this.buildTree(0, this.sorted.size(), 0, this.sorted.iter());
    }

    private void buildTree(int n, int n2, int n3, DoubleDBIDListMIter doubleDBIDListMIter) {
        assert (n < n2);
        doubleDBIDListMIter.seek(n);
        while (doubleDBIDListMIter.getOffset() < n2) {
            doubleDBIDListMIter.setDouble(((NumberVector)this.relation.get(doubleDBIDListMIter)).doubleValue(n3));
            this.countObjectAccess();
            doubleDBIDListMIter.advance();
        }
        if (n2 - n <= this.leafsize) {
            return;
        }
        int n4 = n + n2 >>> 1;
        QuickSelect.quickSelect(this.sorted, n, n2, n4);
        int n5 = (n3 + 1) % this.dims;
        if (n < n4) {
            this.buildTree(n, n4, n5, doubleDBIDListMIter);
        }
        if (++n4 < n2) {
            this.buildTree(n4, n2, n5, doubleDBIDListMIter);
        }
    }

    @Override
    public String getLongName() {
        return "kd-tree";
    }

    @Override
    public String getShortName() {
        return "kd-tree";
    }

    @Override
    public void logStatistics() {
        if (this.objaccess != null) {
            LOG.statistics(this.objaccess);
        }
        if (this.distcalc != null) {
            LOG.statistics(this.distcalc);
        }
    }

    protected void countObjectAccess() {
        if (this.objaccess != null) {
            this.objaccess.increment();
        }
    }

    protected void countDistanceComputation() {
        if (this.distcalc != null) {
            this.distcalc.increment();
        }
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (distanceFunction instanceof LPNormDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)distanceFunction);
        }
        if (distanceFunction instanceof SquaredEuclideanDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)distanceFunction);
        }
        if (distanceFunction instanceof SparseLPNormDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)distanceFunction);
        }
        return null;
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (distanceFunction instanceof LPNormDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)distanceFunction);
        }
        if (distanceFunction instanceof SquaredEuclideanDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)distanceFunction);
        }
        if (distanceFunction instanceof SparseLPNormDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)distanceFunction);
        }
        return null;
    }

    @Alias(value={"smallkd", "kd"})
    public static class Factory<O extends NumberVector>
    implements IndexFactory<O, SmallMemoryKDTree<O>> {
        int leafsize;

        public Factory() {
            this(1);
        }

        public Factory(int n) {
            this.leafsize = n;
        }

        @Override
        public SmallMemoryKDTree<O> instantiate(Relation<O> relation) {
            return new SmallMemoryKDTree<O>(relation, this.leafsize);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer<O extends NumberVector>
        extends AbstractParameterizer {
            int leafsize;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                super.makeOptions(parameterization);
                IntParameter intParameter = (IntParameter)new IntParameter(MinimalisticMemoryKDTree.Factory.Parameterizer.LEAFSIZE_P, 1).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.leafsize = intParameter.intValue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.leafsize);
            }
        }
    }

    public class KDTreeRangeQuery
    extends AbstractDistanceRangeQuery<O> {
        private Norm<? super O> norm;

        public KDTreeRangeQuery(DistanceQuery<O> distanceQuery, Norm<? super O> norm) {
            super(distanceQuery);
            this.norm = norm;
        }

        @Override
        public void getRangeForObject(O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
            this.kdRangeSearch(0, SmallMemoryKDTree.this.sorted.size(), 0, o, modifiableDoubleDBIDList, SmallMemoryKDTree.this.sorted.iter(), d);
        }

        private void kdRangeSearch(int n, int n2, int n3, O o, ModifiableDoubleDBIDList modifiableDoubleDBIDList, DoubleDBIDListIter doubleDBIDListIter, double d) {
            if (n2 - n <= SmallMemoryKDTree.this.leafsize) {
                doubleDBIDListIter.seek(n);
                while (doubleDBIDListIter.getOffset() < n2) {
                    double d2 = this.norm.distance(o, this.relation.get(doubleDBIDListIter));
                    SmallMemoryKDTree.this.countObjectAccess();
                    SmallMemoryKDTree.this.countDistanceComputation();
                    if (d2 <= d) {
                        modifiableDoubleDBIDList.add(d2, doubleDBIDListIter);
                    }
                    doubleDBIDListIter.advance();
                }
                return;
            }
            int n4 = n + n2 >>> 1;
            double d3 = doubleDBIDListIter.seek(n4).doubleValue() - o.doubleValue(n3);
            boolean bl = d3 >= 0.0;
            boolean bl2 = d3 <= 0.0;
            boolean bl3 = Math.abs(d3) <= d;
            int n5 = (n3 + 1) % SmallMemoryKDTree.this.dims;
            if (bl3) {
                NumberVector numberVector = (NumberVector)this.relation.get(doubleDBIDListIter.seek(n4));
                SmallMemoryKDTree.this.countObjectAccess();
                double d4 = this.norm.distance((NumberVector)o, numberVector);
                SmallMemoryKDTree.this.countDistanceComputation();
                if (d4 <= d) {
                    assert (doubleDBIDListIter.getOffset() == n4);
                    modifiableDoubleDBIDList.add(d4, doubleDBIDListIter);
                }
            }
            if (n < n4 && (bl || bl3)) {
                this.kdRangeSearch(n, n4, n5, o, modifiableDoubleDBIDList, doubleDBIDListIter, d);
            }
            if (n4 + 1 < n2 && (bl2 || bl3)) {
                this.kdRangeSearch(n4 + 1, n2, n5, o, modifiableDoubleDBIDList, doubleDBIDListIter, d);
            }
        }
    }

    public class KDTreeKNNQuery
    extends AbstractDistanceKNNQuery<O> {
        private Norm<? super O> norm;

        public KDTreeKNNQuery(DistanceQuery<O> distanceQuery, Norm<? super O> norm) {
            super(distanceQuery);
            this.norm = norm;
        }

        @Override
        public KNNList getKNNForObject(O o, int n) {
            KNNHeap kNNHeap = DBIDUtil.newHeap(n);
            this.kdKNNSearch(0, SmallMemoryKDTree.this.sorted.size(), 0, o, kNNHeap, SmallMemoryKDTree.this.sorted.iter(), Double.POSITIVE_INFINITY);
            return kNNHeap.toKNNList();
        }

        private double kdKNNSearch(int n, int n2, int n3, O o, KNNHeap kNNHeap, DoubleDBIDListIter doubleDBIDListIter, double d) {
            if (n2 - n <= SmallMemoryKDTree.this.leafsize) {
                doubleDBIDListIter.seek(n);
                while (doubleDBIDListIter.getOffset() < n2) {
                    double d2 = this.norm.distance(o, this.relation.get(doubleDBIDListIter));
                    SmallMemoryKDTree.this.countObjectAccess();
                    SmallMemoryKDTree.this.countDistanceComputation();
                    if (d2 <= d) {
                        kNNHeap.insert(d2, doubleDBIDListIter);
                    }
                    d = kNNHeap.getKNNDistance();
                    doubleDBIDListIter.advance();
                }
                return d;
            }
            int n4 = n + n2 >>> 1;
            double d3 = doubleDBIDListIter.seek(n4).doubleValue() - o.doubleValue(n3);
            assert (doubleDBIDListIter.doubleValue() == ((NumberVector)this.relation.get(doubleDBIDListIter)).doubleValue(n3)) : "Tree inconsistent " + n + " < " + n4 + " < " + n2 + ": " + doubleDBIDListIter.doubleValue() + " != " + ((NumberVector)this.relation.get(doubleDBIDListIter)).doubleValue(n3) + " " + this.relation.get(doubleDBIDListIter);
            boolean bl = d3 >= 0.0;
            boolean bl2 = d3 <= 0.0;
            int n5 = (n3 + 1) % SmallMemoryKDTree.this.dims;
            if (bl && bl2) {
                NumberVector numberVector = (NumberVector)this.relation.get(doubleDBIDListIter.seek(n4));
                SmallMemoryKDTree.this.countObjectAccess();
                double d4 = this.norm.distance((NumberVector)o, numberVector);
                SmallMemoryKDTree.this.countDistanceComputation();
                if (d4 <= d) {
                    assert (doubleDBIDListIter.getOffset() == n4);
                    kNNHeap.insert(d4, doubleDBIDListIter);
                    d = kNNHeap.getKNNDistance();
                }
                if (n < n4) {
                    d = this.kdKNNSearch(n, n4, n5, o, kNNHeap, doubleDBIDListIter, d);
                }
                if (n4 + 1 < n2) {
                    d = this.kdKNNSearch(n4 + 1, n2, n5, o, kNNHeap, doubleDBIDListIter, d);
                }
            } else if (bl) {
                if (n < n4) {
                    d = this.kdKNNSearch(n, n4, n5, o, kNNHeap, doubleDBIDListIter, d);
                }
                if (Math.abs(d3) <= d) {
                    NumberVector numberVector = (NumberVector)this.relation.get(doubleDBIDListIter.seek(n4));
                    SmallMemoryKDTree.this.countObjectAccess();
                    double d5 = this.norm.distance((NumberVector)o, numberVector);
                    SmallMemoryKDTree.this.countDistanceComputation();
                    if (d5 <= d) {
                        assert (doubleDBIDListIter.getOffset() == n4);
                        kNNHeap.insert(d5, doubleDBIDListIter);
                        d = kNNHeap.getKNNDistance();
                    }
                }
                if (n4 + 1 < n2 && Math.abs(d3) <= d) {
                    d = this.kdKNNSearch(n4 + 1, n2, n5, o, kNNHeap, doubleDBIDListIter, d);
                }
            } else {
                if (n4 + 1 < n2) {
                    d = this.kdKNNSearch(n4 + 1, n2, n5, o, kNNHeap, doubleDBIDListIter, d);
                }
                if (Math.abs(d3) <= d) {
                    NumberVector numberVector = (NumberVector)this.relation.get(doubleDBIDListIter.seek(n4));
                    SmallMemoryKDTree.this.countObjectAccess();
                    double d6 = this.norm.distance((NumberVector)o, numberVector);
                    SmallMemoryKDTree.this.countDistanceComputation();
                    if (d6 <= d) {
                        doubleDBIDListIter.seek(n4);
                        kNNHeap.insert(d6, doubleDBIDListIter);
                        d = kNNHeap.getKNNDistance();
                    }
                }
                if (n < n4 && Math.abs(d3) <= d) {
                    d = this.kdKNNSearch(n, n4, n5, o, kNNHeap, doubleDBIDListIter, d);
                }
            }
            return d;
        }
    }
}

