/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

@Alias(value={"lognormal"})
public class LogNormalDistribution
extends AbstractDistribution {
    private double logmean;
    private double logstddev;
    private double shift = 0.0;

    public LogNormalDistribution(double d, double d2, double d3, Random random) {
        super(random);
        this.logmean = d;
        this.logstddev = d2;
        this.shift = d3;
    }

    public LogNormalDistribution(double d, double d2, double d3, RandomFactory randomFactory) {
        super(randomFactory);
        this.logmean = d;
        this.logstddev = d2;
        this.shift = d3;
    }

    public LogNormalDistribution(double d, double d2, double d3) {
        this(d, d2, d3, (Random)null);
    }

    @Override
    public double pdf(double d) {
        return LogNormalDistribution.pdf(d - this.shift, this.logmean, this.logstddev);
    }

    @Override
    public double cdf(double d) {
        return LogNormalDistribution.cdf(d - this.shift, this.logmean, this.logstddev);
    }

    @Override
    public double quantile(double d) {
        return LogNormalDistribution.quantile(d, this.logmean, this.logstddev) + this.shift;
    }

    public static double pdf(double d, double d2, double d3) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d4 = Math.log(d) - d2;
        double d5 = d3 * d3;
        return 1.0 / (MathUtil.SQRTTWOPI * d3 * d) * Math.exp(-0.5 * d4 * d4 / d5);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d <= 0.0) {
            return 0.0;
        }
        return 0.5 * (1.0 + NormalDistribution.erf((Math.log(d) - d2) / (MathUtil.SQRT2 * d3)));
    }

    public static double quantile(double d, double d2, double d3) {
        return Math.exp(d2 + d3 * NormalDistribution.standardNormalQuantile(d));
    }

    @Override
    public double nextRandom() {
        return Math.exp(this.logmean + this.random.nextGaussian() * this.logstddev) + this.shift;
    }

    @Override
    public String toString() {
        return "LogNormalDistribution(logmean=" + this.logmean + ", logstddev=" + this.logstddev + ", shift=" + this.shift + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID LOGMEAN_ID = new OptionID("distribution.lognormal.logmean", "Mean of the distribution before logscaling.");
        public static final OptionID LOGSTDDEV_ID = new OptionID("distribution.lognormal.logstddev", "Standard deviation of the distribution before logscaling.");
        public static final OptionID SHIFT_ID = new OptionID("distribution.lognormal.shift", "Shifting offset, so the distribution does not begin at 0.");
        double shift;
        double logmean;
        double logsigma;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(LOGMEAN_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.logmean = doubleParameter2.doubleValue();
            }
            DoubleParameter doubleParameter3 = new DoubleParameter(LOGSTDDEV_ID);
            doubleParameter3.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter3)) {
                this.logsigma = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHIFT_ID, 0.0))) {
                this.shift = doubleParameter.doubleValue();
            }
        }

        @Override
        protected LogNormalDistribution makeInstance() {
            return new LogNormalDistribution(this.logmean, this.logsigma, this.shift, this.rnd);
        }
    }
}

