/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayDBIDsAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.FeatureVectorAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.FlatMatrixAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.FloatArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.IdentityArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ListArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberListArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberVectorAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.VectorAdapter;
import java.util.List;

public final class ArrayLikeUtil {
    private static final ListArrayAdapter<Object> LISTADAPTER = new ListArrayAdapter();
    private static final NumberListArrayAdapter<Number> NUMBERLISTADAPTER = new NumberListArrayAdapter();
    private static final IdentityArrayAdapter<?> IDENTITYADAPTER = new IdentityArrayAdapter();
    public static final FeatureVectorAdapter<?> FEATUREVECTORADAPTER = new FeatureVectorAdapter();
    public static final NumberVectorAdapter NUMBERVECTORADAPTER = new NumberVectorAdapter();
    public static final FlatMatrixAdapter FLATMATRIXADAPTER = new FlatMatrixAdapter();
    public static final NumberArrayAdapter<Double, double[]> DOUBLEARRAYADAPTER = new DoubleArrayAdapter();
    public static final NumberArrayAdapter<Float, float[]> FLOATARRAYADAPTER = new FloatArrayAdapter();
    public static final ArrayDBIDsAdapter ARRAYDBIDADAPTER = new ArrayDBIDsAdapter();
    public static final NumberArrayAdapter<Double, Vector> VECTORADAPTER = new VectorAdapter();

    private ArrayLikeUtil() {
    }

    public static <T> ArrayAdapter<T, List<? extends T>> listAdapter(List<? extends T> list) {
        return LISTADAPTER;
    }

    public static <T extends Number> NumberArrayAdapter<T, List<? extends T>> numberListAdapter(List<? extends T> list) {
        return NUMBERLISTADAPTER;
    }

    public static <T> IdentityArrayAdapter<T> identityAdapter(T t) {
        return IDENTITYADAPTER;
    }

    public static <F> FeatureVectorAdapter<F> featureVectorAdapter(FeatureVector<F> featureVector) {
        return FEATUREVECTORADAPTER;
    }

    public static NumberVectorAdapter numberVectorAdapter(NumberVector numberVector) {
        return NUMBERVECTORADAPTER;
    }

    public static NumberArrayAdapter<Double, double[]> doubleArrayAdapter() {
        return DOUBLEARRAYADAPTER;
    }

    public static <A> int getIndexOfMaximum(A a, NumberArrayAdapter<?, A> numberArrayAdapter) throws IndexOutOfBoundsException {
        int n = numberArrayAdapter.size(a);
        int n2 = 0;
        double d = numberArrayAdapter.getDouble(a, 0);
        for (int i = 1; i < n; ++i) {
            double d2 = numberArrayAdapter.getDouble(a, i);
            if (!(d2 > d)) continue;
            d = d2;
            n2 = i;
        }
        return n2;
    }

    public static int getIndexOfMaximum(double[] dArray) throws IndexOutOfBoundsException {
        return ArrayLikeUtil.getIndexOfMaximum(dArray, DOUBLEARRAYADAPTER);
    }

    public static <A> double[] toPrimitiveDoubleArray(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
        if (numberArrayAdapter == DOUBLEARRAYADAPTER) {
            return (double[])((double[])a).clone();
        }
        double[] dArray = new double[numberArrayAdapter.size(a)];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = numberArrayAdapter.getDouble(a, i);
        }
        return dArray;
    }

    public static double[] toPrimitiveDoubleArray(List<? extends Number> list) {
        return ArrayLikeUtil.toPrimitiveDoubleArray(list, NUMBERLISTADAPTER);
    }

    public static double[] toPrimitiveDoubleArray(NumberVector numberVector) {
        return ArrayLikeUtil.toPrimitiveDoubleArray(numberVector, ArrayLikeUtil.numberVectorAdapter(numberVector));
    }

    public static <A> float[] toPrimitiveFloatArray(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
        if (numberArrayAdapter == FLOATARRAYADAPTER) {
            return (float[])((float[])a).clone();
        }
        float[] fArray = new float[numberArrayAdapter.size(a)];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = numberArrayAdapter.getFloat(a, i);
        }
        return fArray;
    }

    public static float[] toPrimitiveFloatArray(List<? extends Number> list) {
        return ArrayLikeUtil.toPrimitiveFloatArray(list, NUMBERLISTADAPTER);
    }

    public static float[] toPrimitiveFloatArray(NumberVector numberVector) {
        return ArrayLikeUtil.toPrimitiveFloatArray(numberVector, ArrayLikeUtil.numberVectorAdapter(numberVector));
    }

    public static <A> int[] toPrimitiveIntegerArray(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
        int[] nArray = new int[numberArrayAdapter.size(a)];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = numberArrayAdapter.getInteger(a, i);
        }
        return nArray;
    }

    public static int[] toPrimitiveIntegerArray(List<? extends Number> list) {
        return ArrayLikeUtil.toPrimitiveIntegerArray(list, NUMBERLISTADAPTER);
    }

    public static int[] toPrimitiveIntegerArray(NumberVector numberVector) {
        return ArrayLikeUtil.toPrimitiveIntegerArray(numberVector, ArrayLikeUtil.numberVectorAdapter(numberVector));
    }
}

