/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.List;
import org.jgap.BaseGeneticOperator;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.RandomGenerator;

public class InversionOperator
extends BaseGeneticOperator {
    private static final String CVS_REVISION = "$Revision: 1.11 $";

    public InversionOperator() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public InversionOperator(Configuration a_config) throws InvalidConfigurationException {
        super(a_config);
    }

    public void operate(Population a_population, List a_candidateChromosomes) {
        int j;
        int size = Math.min(this.getConfiguration().getPopulationSize(), a_population.size());
        RandomGenerator generator = this.getConfiguration().getRandomGenerator();
        int index1 = generator.nextInt(size);
        IChromosome chrom1 = a_population.getChromosome(index1);
        IChromosome firstMate = (IChromosome)chrom1.clone();
        if (this.m_monitorActive) {
            firstMate.setUniqueIDTemplate(chrom1.getUniqueID(), 1);
        }
        Gene[] firstGenes = firstMate.getGenes();
        int locus = generator.nextInt(firstGenes.length);
        Gene[] invertedGenes = new Gene[firstGenes.length];
        int index = 0;
        int len = firstGenes.length;
        for (j = locus; j < len; ++j) {
            invertedGenes[index++] = firstGenes[j];
        }
        for (j = 0; j < locus; ++j) {
            invertedGenes[index++] = firstGenes[j];
        }
        try {
            firstMate.setGenes(invertedGenes);
        }
        catch (InvalidConfigurationException cex) {
            throw new Error(cex);
        }
        a_candidateChromosomes.add(firstMate);
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        InversionOperator op = (InversionOperator)a_other;
        return 0;
    }
}

