/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.io.Serializable;
import org.jgap.RandomGenerator;

public class RandomGeneratorForTesting
implements RandomGenerator,
Serializable {
    private static final String CVS_REVISION = "$Revision: 1.2 $";
    private long m_nextLong;
    private double m_nextDouble;
    private boolean m_nextBoolean;
    private int[] m_nextIntSequence;
    private float[] m_nextFloatSequence;
    private double m_nextGaussian;
    private int m_intIndex;
    private int m_floatIndex;

    public RandomGeneratorForTesting() {
    }

    public RandomGeneratorForTesting(int a_nextInt) {
        this();
        this.setNextInt(a_nextInt);
    }

    public RandomGeneratorForTesting(double a_nextDouble) {
        this();
        this.setNextDouble(a_nextDouble);
    }

    public RandomGeneratorForTesting(float a_nextFloat) {
        this();
        this.setNextFloat(a_nextFloat);
    }

    public RandomGeneratorForTesting(long a_nextLong) {
        this();
        this.setNextLong(a_nextLong);
    }

    public RandomGeneratorForTesting(boolean a_nextBoolean) {
        this();
        this.setNextBoolean(a_nextBoolean);
        this.setNextInt(1);
    }

    public int nextInt() {
        int result = this.m_nextIntSequence[this.m_intIndex++];
        if (this.m_intIndex >= this.m_nextIntSequence.length) {
            this.m_intIndex = 0;
        }
        return result;
    }

    public int nextInt(int a_ceiling) {
        return this.nextInt() % a_ceiling;
    }

    public long nextLong() {
        return this.m_nextLong;
    }

    public double nextDouble() {
        return this.m_nextDouble;
    }

    public double nextGaussian() {
        return this.m_nextGaussian;
    }

    public float nextFloat() {
        float result = this.m_nextFloatSequence[this.m_floatIndex++];
        if (this.m_floatIndex >= this.m_nextFloatSequence.length) {
            this.m_floatIndex = 0;
        }
        return result;
    }

    public boolean nextBoolean() {
        return this.m_nextBoolean;
    }

    public void setNextBoolean(boolean a_nextBoolean) {
        this.m_nextBoolean = a_nextBoolean;
    }

    public void setNextDouble(double a_nextDouble) {
        this.m_nextDouble = a_nextDouble % 1.0;
    }

    public void setNextGaussian(double a_nextDouble) {
        this.m_nextGaussian = a_nextDouble;
    }

    public void setNextFloat(float a_nextFloat) {
        this.setNextFloatSequence(new float[]{a_nextFloat % 1.0f});
    }

    public void setNextInt(int a_nextInt) {
        this.setNextIntSequence(new int[]{a_nextInt});
    }

    public void setNextLong(long a_nextLong) {
        this.m_nextLong = a_nextLong;
    }

    public void setNextFloatSequence(float[] a_sequence) {
        this.m_floatIndex = 0;
        this.m_nextFloatSequence = a_sequence;
    }

    public void setNextIntSequence(int[] a_sequence) {
        this.m_intIndex = 0;
        this.m_nextIntSequence = a_sequence;
    }
}

