/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.IntegerDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.result.BasicResult;

public class PointerHierarchyRepresentationResult
extends BasicResult {
    DBIDs ids;
    DBIDDataStore parent;
    DoubleDataStore parentDistance;
    IntegerDataStore positions = null;

    public PointerHierarchyRepresentationResult(DBIDs dBIDs, DBIDDataStore dBIDDataStore, DoubleDataStore doubleDataStore) {
        super("Pointer Representation", "pointer-representation");
        this.ids = dBIDs;
        this.parent = dBIDDataStore;
        this.parentDistance = doubleDataStore;
    }

    public DBIDs getDBIDs() {
        return this.ids;
    }

    public DBIDDataStore getParentStore() {
        return this.parent;
    }

    public DoubleDataStore getParentDistanceStore() {
        return this.parentDistance;
    }

    public IntegerDataStore getPositions() {
        if (this.positions != null) {
            return this.positions;
        }
        ArrayDBIDs arrayDBIDs = PointerHierarchyRepresentationResult.topologicalSort(this.ids, this.parent, this.parentDistance);
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        int n = arrayDBIDs.size() - 1;
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(this.ids, 30, 1);
        DBIDVar dBIDVar = DBIDUtil.newVar();
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.valid()) {
            if (!DBIDUtil.equal(dBIDArrayIter, this.parent.assignVar(dBIDArrayIter, dBIDVar))) {
                writableIntegerDataStore.increment(dBIDVar, writableIntegerDataStore.intValue(dBIDArrayIter));
            }
            dBIDArrayIter.advance();
        }
        WritableIntegerDataStore writableIntegerDataStore2 = DataStoreUtil.makeIntegerStorage(this.ids, 30, -1);
        WritableIntegerDataStore writableIntegerDataStore3 = DataStoreUtil.makeIntegerStorage(this.ids, 3, -1);
        int n2 = 0;
        dBIDArrayIter.seek(n);
        while (dBIDArrayIter.valid()) {
            int n3 = writableIntegerDataStore.intValue(dBIDArrayIter);
            this.parent.assignVar(dBIDArrayIter, dBIDVar);
            int n4 = writableIntegerDataStore3.intValue(dBIDVar);
            if (n4 < 0 || DBIDUtil.equal(dBIDArrayIter, dBIDVar)) {
                writableIntegerDataStore3.putInt(dBIDArrayIter, n2);
                writableIntegerDataStore2.putInt(dBIDArrayIter, n2 + n3 - 1);
                n2 += n3;
            } else {
                writableIntegerDataStore2.putInt(dBIDArrayIter, n4 + n3 - 1);
                writableIntegerDataStore3.putInt(dBIDArrayIter, n4);
                writableIntegerDataStore3.increment(dBIDVar, n3);
            }
            dBIDArrayIter.retract();
        }
        writableIntegerDataStore3.destroy();
        this.positions = writableIntegerDataStore2;
        return this.positions;
    }

    public static ArrayDBIDs topologicalSort(DBIDs dBIDs, DBIDDataStore dBIDDataStore, DoubleDataStore doubleDataStore) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs);
        arrayModifiableDBIDs.sort(new DataStoreUtil.DescendingByDoubleDataStoreAndId(doubleDataStore));
        int n = arrayModifiableDBIDs.size();
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(n);
        ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray(n);
        DBIDVar dBIDVar = DBIDUtil.newVar();
        DBIDVar dBIDVar2 = DBIDUtil.newVar();
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        while (dBIDArrayMIter.valid()) {
            if (hashSetModifiableDBIDs.add(dBIDArrayMIter)) {
                arrayModifiableDBIDs2.add(dBIDArrayMIter);
                dBIDVar2.set(dBIDArrayMIter);
                while (!DBIDUtil.equal(dBIDVar2, dBIDDataStore.assignVar(dBIDVar2, dBIDVar)) && hashSetModifiableDBIDs.add(dBIDVar)) {
                    arrayModifiableDBIDs2.add(dBIDVar);
                    dBIDVar2.set(dBIDVar);
                }
            }
            dBIDArrayMIter.advance();
        }
        int n2 = 0;
        for (int i = n - 1; n2 < i; ++n2, --i) {
            arrayModifiableDBIDs2.swap(n2, i);
        }
        return arrayModifiableDBIDs2;
    }
}

