/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.AbstractOPTICS;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="OPTICS: Density-Based Hierarchical Clustering")
@Description(value="Algorithm to find density-connected sets in a database based on the parameters 'minPts' and 'epsilon' (specifying a volume). These two parameters determine a density threshold for clustering.")
@Reference(authors="M. Ankerst, M. Breunig, H.-P. Kriegel, and J. Sander", title="OPTICS: Ordering Points to Identify the Clustering Structure", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="http://dx.doi.org/10.1145/304181.304187")
public class OPTICSList<O>
extends AbstractOPTICS<O> {
    private static final Logging LOG = Logging.getLogger(OPTICSList.class);

    public OPTICSList(DistanceFunction<? super O> distanceFunction, double d, int n) {
        super(distanceFunction, d, n);
    }

    @Override
    public ClusterOrder run(Database database, Relation<O> relation) {
        return new Instance(database, relation).run();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractOPTICS.Parameterizer<O> {
        @Override
        protected OPTICSList<O> makeInstance() {
            return new OPTICSList(this.distanceFunction, this.epsilon, this.minpts);
        }
    }

    private class Instance {
        ModifiableDBIDs processedIDs;
        ArrayModifiableDBIDs candidates;
        WritableDBIDDataStore predecessor;
        WritableDoubleDataStore reachability;
        ClusterOrder clusterOrder;
        DBIDs ids;
        FiniteProgress progress;
        RangeQuery<O> rangeQuery;

        public Instance(Database database, Relation<O> relation) {
            this.ids = relation.getDBIDs();
            this.processedIDs = DBIDUtil.newHashSet(this.ids.size());
            this.candidates = DBIDUtil.newArray();
            this.predecessor = DataStoreUtil.makeDBIDStorage(this.ids, 2);
            this.reachability = DataStoreUtil.makeDoubleStorage(this.ids, 30, Double.POSITIVE_INFINITY);
            this.clusterOrder = new ClusterOrder(this.ids, "OPTICS Clusterorder", "optics-clusterorder");
            this.progress = LOG.isVerbose() ? new FiniteProgress("OPTICS", this.ids.size(), LOG) : null;
            DistanceQuery distanceQuery = database.getDistanceQuery(relation, OPTICSList.this.getDistanceFunction(), new Object[0]);
            this.rangeQuery = database.getRangeQuery(distanceQuery, OPTICSList.this.epsilon);
        }

        public ClusterOrder run() {
            DBIDIter dBIDIter = this.ids.iter();
            while (dBIDIter.valid()) {
                if (!this.processedIDs.contains(dBIDIter)) {
                    this.expandClusterOrder(dBIDIter);
                }
                dBIDIter.advance();
            }
            LOG.ensureCompleted(this.progress);
            return this.clusterOrder;
        }

        protected void expandClusterOrder(DBIDRef dBIDRef) {
            ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
            DoubleDBIDListMIter doubleDBIDListMIter = modifiableDoubleDBIDList.iter();
            this.candidates.add(dBIDRef);
            this.predecessor.putDBID(dBIDRef, dBIDRef);
            this.reachability.put(dBIDRef, Double.POSITIVE_INFINITY);
            DBIDArrayMIter dBIDArrayMIter = this.candidates.iter();
            DBIDVar dBIDVar = DBIDUtil.newVar();
            DBIDVar dBIDVar2 = DBIDUtil.newVar();
            while (!this.candidates.isEmpty()) {
                this.findBest(this.candidates, dBIDArrayMIter, dBIDVar);
                this.processedIDs.add(dBIDVar);
                this.predecessor.assignVar(dBIDVar, dBIDVar2);
                double d = this.reachability.doubleValue(dBIDVar);
                this.clusterOrder.add(dBIDVar, d, dBIDVar2);
                LOG.incrementProcessed(this.progress);
                modifiableDoubleDBIDList.clear();
                this.rangeQuery.getRangeForDBID(dBIDVar, OPTICSList.this.epsilon, modifiableDoubleDBIDList);
                if (modifiableDoubleDBIDList.size() < OPTICSList.this.minpts) continue;
                modifiableDoubleDBIDList.sort();
                d = doubleDBIDListMIter.seek(OPTICSList.this.minpts - 1).doubleValue();
                doubleDBIDListMIter.seek(0);
                while (doubleDBIDListMIter.valid()) {
                    double d2;
                    double d3;
                    if (!this.processedIDs.contains(doubleDBIDListMIter) && (d3 = MathUtil.max(doubleDBIDListMIter.doubleValue(), d)) < (d2 = this.reachability.doubleValue(doubleDBIDListMIter))) {
                        this.reachability.put((DBIDRef)doubleDBIDListMIter, d3);
                        this.predecessor.putDBID(doubleDBIDListMIter, dBIDVar);
                        if (d2 >= Double.POSITIVE_INFINITY) {
                            this.candidates.add(doubleDBIDListMIter);
                        }
                    }
                    doubleDBIDListMIter.advance();
                }
            }
        }

        public void findBest(ArrayModifiableDBIDs arrayModifiableDBIDs, DBIDArrayMIter dBIDArrayMIter, DBIDVar dBIDVar) {
            assert (arrayModifiableDBIDs.size() > 0);
            int n = 0;
            double d = this.reachability.doubleValue(dBIDArrayMIter.seek(0));
            dBIDArrayMIter.advance();
            while (dBIDArrayMIter.valid()) {
                double d2 = this.reachability.doubleValue(dBIDArrayMIter);
                if (d2 < d) {
                    d = d2;
                    n = dBIDArrayMIter.getOffset();
                }
                dBIDArrayMIter.advance();
            }
            dBIDVar.set(dBIDArrayMIter.seek(n));
            dBIDArrayMIter.remove();
        }
    }
}

