/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="T. Hu, and S. Y. Sung", title="Detecting pattern-based outliers", booktitle="Pattern Recognition Letters 24(16)", url="http://dx.doi.org/10.1016/S0167-8655(03)00165-X")
public class VarianceOfVolume<O extends SpatialComparable>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(VarianceOfVolume.class);
    protected int k;

    public VarianceOfVolume(int n, DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
        this.k = n + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("VOV", 3) : null;
        DBIDs dBIDs = relation.getDBIDs();
        int n = RelationUtil.dimensionality(relation);
        LOG.beginStep(stepProgress, 1, "Materializing nearest-neighbor sets.");
        KNNQuery<O> kNNQuery = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepProgress, 2, "Computing Volumes.");
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        this.computeVolumes(kNNQuery, n, dBIDs, writableDoubleDataStore);
        LOG.beginStep(stepProgress, 3, "Computing Variance of Volumes (VOV).");
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(dBIDs, 30);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        this.computeVOVs(kNNQuery, dBIDs, writableDoubleDataStore, writableDoubleDataStore2, doubleMinMax);
        LOG.setCompleted(stepProgress);
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Variance of Volume", "vov-outlier", writableDoubleDataStore2, dBIDs);
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(basicOutlierScoreMeta, materializedDoubleRelation);
    }

    private void computeVolumes(KNNQuery<O> kNNQuery, int n, DBIDs dBIDs, WritableDoubleDataStore writableDoubleDataStore) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Volume", dBIDs.size(), LOG) : null;
        double d = MathUtil.SQRTPI * Math.pow(GammaDistribution.gamma(1.0 + (double)n * 0.5), -1.0 / (double)n);
        boolean bl = false;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d2;
            double d3 = kNNQuery.getKNNForDBID(dBIDIter, this.k).getKNNDistance();
            double d4 = d2 = d3 > 0.0 ? MathUtil.powi(d3 * d, n) : 0.0;
            if (d2 == Double.POSITIVE_INFINITY && !bl) {
                LOG.warning("Variance of Volumes has hit double precision limits, results are not reliable.");
                bl = true;
            }
            writableDoubleDataStore.putDouble(dBIDIter, d2);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    private void computeVOVs(KNNQuery<O> kNNQuery, DBIDs dBIDs, DoubleDataStore doubleDataStore, WritableDoubleDataStore writableDoubleDataStore, DoubleMinMax doubleMinMax) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Variance of Volume", dBIDs.size(), LOG) : null;
        boolean bl = false;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k);
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            double d = 0.0;
            while (doubleDBIDListIter.valid()) {
                d += doubleDataStore.doubleValue(doubleDBIDListIter);
                doubleDBIDListIter.advance();
            }
            d /= (double)kNNList.size();
            double d2 = 0.0;
            doubleDBIDListIter.seek(0);
            while (doubleDBIDListIter.valid()) {
                double d3 = doubleDataStore.doubleValue(doubleDBIDListIter) - d;
                d2 += d3 * d3;
                doubleDBIDListIter.advance();
            }
            if (!(d2 < Double.POSITIVE_INFINITY) && !bl) {
                LOG.warning("Variance of Volumes has hit double precision limits, results are not reliable.");
                bl = true;
            }
            d2 = kNNList.size() > 1 && d2 < Double.POSITIVE_INFINITY ? d2 / (double)(kNNList.size() - 1) : Double.POSITIVE_INFINITY;
            writableDoubleDataStore.putDouble(dBIDIter, d2);
            doubleMinMax.put(d2);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(new CombinedTypeInformation(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.SPATIAL_OBJECT));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends SpatialComparable>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("vov.k", "The number of nearest neighbors (not including the query point) of an object to be considered for computing its VOV score.");
        protected int k = 2;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
        }

        @Override
        protected VarianceOfVolume<O> makeInstance() {
            return new VarianceOfVolume(this.k, this.distanceFunction);
        }
    }
}

